package eu.dnetlib.iis.common;

public abstract class WorkflowRuntimeParameters {

	private WorkflowRuntimeParameters() {}
	
	public static final char DEFAULT_CSV_DELIMITER = ',';
	
	public static final char INFERENCE_PROVENANCE_BLACKLIST_DELIM = DEFAULT_CSV_DELIMITER;
	
	public static final String UNDEFINED_NONEMPTY_VALUE = "$UNDEFINED$";
	
	public static final String IMPORT_INFERENCE_PROVENANCE_BLACKLIST = "import.inference.provenance.blacklist";
	public static final String IMPORT_SKIP_DELETED_BY_INFERENCE = "import.skip.deleted.by.inference";
	public static final String IMPORT_APPROVED_DATASOURCES_CSV = "import.approved.datasources.csv";
	public static final String IMPORT_CONTENT_APPROVED_OBJECSTORES_CSV = "import.content.approved.objectstores.csv";
	public static final String IMPORT_CONTENT_ALLOW_DUPLICATES = "import.content.allow.duplicates";
	public static final String IMPORT_CONTENT_OBJECSTORE_PAGESIZE = "import.content.objectstore.resultset.pagesize";
	
	public static final String IMPORT_HBASE_TABLE_NAME = "import.hbase.table.name";
	public static final String IMPORT_CONTENT_AVRO_LOCATION = "import.hdfs.urlcontent.avro.loc";
	public static final String IMPORT_CONTENT_INDEX_FILE_LOCATION = "import.hdfs.content.index.file.loc";
	
	public static final String IMPORT_CONTENT_CONNECTION_TIMEOUT = "import.content.connection.timeout";
	public static final String IMPORT_CONTENT_READ_TIMEOUT = "import.content.read.timeout";
	public static final String IMPORT_CONTENT_OBJECT_STORE_LOC = "import.content.object.store.location";
	public static final String IMPORT_CONTENT_LOOKUP_SERVICE_LOC = "import.content.lookup.service.location";
	public static final String IMPORT_CONTENT_OBJECT_STORE_IDS_CSV = "import.content.object.store.ids.csv";
	
	public static final String IMPORT_CONTENT_APPROVER_SIZELIMIT_MEGABYTES = "import.content.approver.sizelimit.megabytes";
	
	public static final String IMPORT_DATACITE_MDSTORE_SERVICE_LOCATION = "import.datacite.mdstore.service.location";
	public static final String IMPORT_DATACITE_MDSTORE_ID = "import.datacite.mdstore.id";
	public static final String IMPORT_DATACITE_MDSTORE_FORMAT = "import.datacite.mdstore.format";
	public static final String IMPORT_DATACITE_MDSTORE_PAGESIZE = "import.datacite.mdstore.resultset.pagesize";

	public static final String IMPORT_DOCUMENT_MDSTORE_SERVICE_LOCATION = "import.document.mdstore.service.location";
	public static final String IMPORT_DOCUMENT_MDSTORE_ID = "import.document.mdstore.id";
	
	public static final String IMPORT_DATABASE_SERVICE_LOCATION = "import.database.service.location";
	public static final String IMPORT_DATABASE_SERVICE_DBNAME = "import.database.service.dbname";
	
	public static final String IMPORT_RESULT_SET_CLIENT_READ_TIMEOUT = "import.resultset.client.read.timeout";
	
	public static final String EXPORT_TRUST_LEVEL = "export.trust.level";
	public static final String EXPORT_ACTION_SETID = "export.action.setid";
	public static final String EXPORT_ENTITY_ACTION_SETID = "export.entity.action.setid";
	public static final char EXPORT_ACTION_SET_PROPERTY_SEPARATOR = '.';	
	
	public static final String EXPORT_ACTION_BUILDER_FACTORY_CLASSNAME = "export.action.builder.factory.classname";
	public static final String EXPORT_ACTION_HBASE_TABLE_NAME = "export.action.hbase.table.name";
	public static final String EXPORT_ACTION_HBASE_TABLE_INITIALIZE = "export.action.hbase.table.initialize";
	public static final String EXPORT_ACTION_HBASE_REMOTE_ZOOKEEPER_QUORUM = "export.action.hbase.remote.zookeeper.quorum";
	public static final String EXPORT_ACTION_HBASE_REMOTE_ZOOKEEPER_CLIENTPORT = "export.action.hbase.remote.zookeeper.clientport";
	
	public static final String EXPORT_HBASE_TABLE_NAME = "export.hbase.table.name";
	
	public static final String EXPORT_SKIP_ORIGINAL_METADATA = "export.skip.original.metadata";
	public static final String EXPORT_SKIP_AUTHORS = "export.skip.authors";
	
	public static final String HBASE_ENCODING = "hbase.table.encoding";
	
}
