/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.common.cache;

import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import eu.dnetlib.iis.core.java.HadoopContext;
import eu.dnetlib.iis.core.java.PortBindings;
import eu.dnetlib.iis.core.java.Process;
import eu.dnetlib.iis.core.java.porttype.PortType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class CacheMetadataManagingProcess
implements Process {
    public static final String OUTPUT_PROPERTY_CACHE_ID = "cache_id";
    public static final String PARAM_CACHE_DIR = "default_cache_location";
    public static final String PARAM_MODE = "mode";
    public static final String PARAM_ID = "id";
    public static final String MODE_READ_CURRENT_ID = "read_current_id";
    public static final String MODE_GENERATE_NEW_ID = "generate_new_id";
    public static final String MODE_WRITE_ID = "write_id";
    public static final String DEFAULT_METAFILE_NAME = "meta.json";
    public static final int CACHE_ID_PADDING_LENGTH = 6;
    public static final String NON_EXISTING_CACHE_ID = "$UNDEFINED$";
    public static final String OOZIE_ACTION_OUTPUT_FILENAME = "oozie.action.output.properties";
    public static final String DEFAULT_ENCODING = "UTF-8";

    public Map<String, PortType> getInputPorts() {
        return Collections.emptyMap();
    }

    public Map<String, PortType> getOutputPorts() {
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getExistingCacheId(HadoopContext context, Map<String, String> parameters) throws IOException {
        if (parameters.containsKey(PARAM_CACHE_DIR)) {
            Path cacheFilePath;
            FileSystem fs = FileSystem.get((Configuration)context.getConfiguration());
            if (fs.exists(cacheFilePath = new Path(parameters.get(PARAM_CACHE_DIR), DEFAULT_METAFILE_NAME))) {
                FSDataInputStream inputStream = fs.open(cacheFilePath);
                InputStreamReader reader = new InputStreamReader((InputStream)inputStream, DEFAULT_ENCODING);
                try {
                    Gson gson = new Gson();
                    CacheMeta cacheMeta = (CacheMeta)gson.fromJson((Reader)reader, CacheMeta.class);
                    String string = cacheMeta.getCurrentCacheId();
                    return string;
                }
                finally {
                    reader.close();
                    inputStream.close();
                }
            }
            return NON_EXISTING_CACHE_ID;
        }
        throw new RuntimeException("cache directory location not provided! 'default_cache_location' parameter is missing!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String generateNewCacheId(HadoopContext context, Map<String, String> parameters) throws IOException {
        if (parameters.containsKey(PARAM_CACHE_DIR)) {
            FileSystem fs = FileSystem.get((Configuration)context.getConfiguration());
            Path cacheFilePath = new Path(parameters.get(PARAM_CACHE_DIR), DEFAULT_METAFILE_NAME);
            CacheMeta cachedMeta = null;
            if (fs.exists(cacheFilePath)) {
                FSDataInputStream inputStream = fs.open(cacheFilePath);
                InputStreamReader reader = new InputStreamReader((InputStream)inputStream, DEFAULT_ENCODING);
                try {
                    Gson gson = new Gson();
                    cachedMeta = (CacheMeta)gson.fromJson((Reader)reader, CacheMeta.class);
                }
                finally {
                    reader.close();
                    inputStream.close();
                }
            }
            if (cachedMeta != null) {
                int currentIndex = CacheMetadataManagingProcess.convertCacheIdToInt(cachedMeta.getCurrentCacheId());
                return CacheMetadataManagingProcess.convertIntToCacheId(currentIndex + 1);
            }
            return CacheMetadataManagingProcess.convertIntToCacheId(1);
        }
        throw new RuntimeException("cache directory location not provided! 'default_cache_location' parameter is missing!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeCacheId(HadoopContext context, Map<String, String> parameters) throws IOException {
        if (parameters.containsKey(PARAM_CACHE_DIR)) {
            if (parameters.containsKey(PARAM_ID)) {
                String cacheId = parameters.get(PARAM_ID);
                FileSystem fs = FileSystem.get((Configuration)context.getConfiguration());
                Path cacheFilePath = new Path(parameters.get(PARAM_CACHE_DIR), DEFAULT_METAFILE_NAME);
                CacheMeta cachedMeta = null;
                if (fs.exists(cacheFilePath)) {
                    FSDataInputStream inputStream = fs.open(cacheFilePath);
                    InputStreamReader reader = new InputStreamReader((InputStream)inputStream, DEFAULT_ENCODING);
                    try {
                        Gson gson = new Gson();
                        cachedMeta = (CacheMeta)gson.fromJson((Reader)reader, CacheMeta.class);
                    }
                    finally {
                        reader.close();
                        inputStream.close();
                    }
                }
                if (cachedMeta == null) {
                    cachedMeta = new CacheMeta();
                }
                cachedMeta.setCurrentCacheId(cacheId);
                Gson gson = new Gson();
                FSDataOutputStream outputStream = fs.create(cacheFilePath, true);
                JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)outputStream, DEFAULT_ENCODING));
                try {
                    gson.toJson((Object)cachedMeta, CacheMeta.class, writer);
                }
                finally {
                    writer.close();
                    outputStream.close();
                }
            }
            throw new RuntimeException("unable to write new cache id in meta.json file, no 'id' input parameter provied!");
        }
        throw new RuntimeException("cache directory location not provided! 'default_cache_location' parameter is missing!");
    }

    protected static int convertCacheIdToInt(String cacheId) {
        StringBuffer strBuff = new StringBuffer(cacheId);
        while (strBuff.charAt(0) == '0') {
            strBuff.deleteCharAt(0);
        }
        return Integer.parseInt(strBuff.toString());
    }

    protected static String convertIntToCacheId(int cacheIndex) {
        StringBuffer strBuff = new StringBuffer(String.valueOf(cacheIndex));
        while (strBuff.length() < 6) {
            strBuff.insert(0, '0');
        }
        return strBuff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(PortBindings portBindings, HadoopContext context, Map<String, String> parameters) throws Exception {
        String mode = parameters.get(PARAM_MODE);
        File file = new File(System.getProperty(OOZIE_ACTION_OUTPUT_FILENAME));
        Properties props = new Properties();
        if (MODE_READ_CURRENT_ID.equals(mode)) {
            props.setProperty(OUTPUT_PROPERTY_CACHE_ID, this.getExistingCacheId(context, parameters));
        } else if (MODE_GENERATE_NEW_ID.equals(mode)) {
            props.setProperty(OUTPUT_PROPERTY_CACHE_ID, this.generateNewCacheId(context, parameters));
        } else if (MODE_WRITE_ID.equals(mode)) {
            this.writeCacheId(context, parameters);
        } else {
            throw new RuntimeException("unsupported mode: " + mode);
        }
        FileOutputStream os = new FileOutputStream(file);
        try {
            props.store(os, "");
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    public class CacheMeta {
        protected String currentCacheId;

        public String getCurrentCacheId() {
            return this.currentCacheId;
        }

        public void setCurrentCacheId(String currentCacheId) {
            this.currentCacheId = currentCacheId;
        }
    }
}

