/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.common.protobuf;

import com.google.protobuf.Message;
import eu.dnetlib.iis.common.protobuf.AvroToProtoBufConverter;
import java.io.IOException;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.mapred.AvroKey;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.log4j.Logger;

public class AvroToProtoBufOneToOneMapper<IN extends IndexedRecord, OUT extends Message>
extends Mapper<AvroKey<IN>, NullWritable, Text, BytesWritable> {
    private static final String CONVERTER_CLASS_PROPERTY = "converter_class";
    private final Logger log = Logger.getLogger(AvroToProtoBufOneToOneMapper.class);
    private final Text keyWritable = new Text();
    private final BytesWritable valueWritable = new BytesWritable();
    private AvroToProtoBufConverter<IN, OUT> converter;

    public void setup(Mapper.Context context) throws IOException, InterruptedException {
        Class converterClass = context.getConfiguration().getClass(CONVERTER_CLASS_PROPERTY, null);
        if (converterClass == null) {
            throw new IOException("Please specify converter_class");
        }
        try {
            this.converter = (AvroToProtoBufConverter)converterClass.newInstance();
        }
        catch (ClassCastException e) {
            throw new IOException("Class specified in converter_class doesn't implement AvroToProtoBufConverter");
        }
        catch (Exception e) {
            throw new IOException("Could not instantiate specified AvroToProtoBufConverter class, " + converterClass, e);
        }
    }

    public void map(AvroKey<IN> avro, NullWritable ignore, Mapper.Context context) throws IOException, InterruptedException {
        String key = null;
        try {
            key = this.converter.convertIntoKey((IndexedRecord)avro.datum());
            this.keyWritable.set(key);
            byte[] value = this.converter.convertIntoValue((IndexedRecord)avro.datum()).toByteArray();
            this.valueWritable.set(value, 0, value.length);
            context.write((Object)this.keyWritable, (Object)this.valueWritable);
        }
        catch (Exception e) {
            this.log.error((Object)("Error" + (key != null ? " while processing  " + key : "")), (Throwable)e);
        }
    }
}

