/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.common.oozie;

import java.security.InvalidParameterException;
import java.util.List;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.WorkflowJob;

public class ExecutedJobChecker {
    public static void main(String[] args) throws Exception {
        if (args.length == 3) {
            OozieClient client = new OozieClient(args[0]);
            StringBuffer filter = new StringBuffer();
            filter.append("name");
            filter.append('=');
            filter.append(args[1]);
            filter.append(';');
            filter.append("status");
            filter.append('=');
            filter.append("RUNNING");
            List wfJobs = client.getJobsInfo(filter.toString());
            if (wfJobs.size() > 0) {
                for (WorkflowJob currentJob : wfJobs) {
                    if (args[2].equals(currentJob.getId())) continue;
                    throw new RuntimeException("job " + args[1] + " is currently running! Job details: " + ExecutedJobChecker.generateJobDetails(currentJob));
                }
            }
        } else {
            throw new InvalidParameterException("invalid number arguments: " + args.length + ", expected: 3");
        }
    }

    private static String generateJobDetails(WorkflowJob job) {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append("jobId: ");
        strBuff.append(job.getId());
        strBuff.append(", started at: ");
        strBuff.append(job.getStartTime());
        strBuff.append(", last modified at: ");
        strBuff.append(job.getLastModifiedTime());
        return strBuff.toString();
    }
}

