package eu.dnetlib.iis.export.actionmanager.module;

/**
 * Action builder factory providing {@link ActionBuilderModule} objects.
 * @author mhorst
 *
 * @param <T>
 */
public interface ActionBuilderFactory<T> {

	/**
	 * Instantiates action builder module.
	 * @param predefinedTrust
	 * @param actionSetId
	 * @return
	 */
	ActionBuilderModule<T> instantiate(String predefinedTrust, String actionSetId);

	/**
	 * Provides algorithm name.
	 * @return algorithm name
	 */
	AlgorithmName getAlgorithName();
	
}
