package eu.dnetlib.iis.export.actionmanager.module;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.OafProtos.Oaf;
import eu.dnetlib.data.proto.OafProtos.OafEntity;
import eu.dnetlib.data.proto.ResultProtos.Result;
import eu.dnetlib.data.proto.ResultProtos.Result.Context;
import eu.dnetlib.data.proto.ResultProtos.Result.Metadata;
import eu.dnetlib.data.proto.TypeProtos.Type;
import eu.dnetlib.iis.export.schemas.DocumentToResearchInitiatives;

/**
 * {@link DocumentToResearchInitiatives} action builder module.
 * @author mhorst
 *
 */
public class DocumentToResearchInitiativesActionBuilderModuleFactory 
	implements ActionBuilderFactory<DocumentToResearchInitiatives> {

	class DocumentToResearchInitiativesActionBuilderModule extends
	AbstractBuilderModule implements ActionBuilderModule<DocumentToResearchInitiatives> {
	
		/**
		 * Default constructor.
		 * @param predefinedTrust
		 * @param actionSetId
		 */
		public DocumentToResearchInitiativesActionBuilderModule(
				String predefinedTrust, String actionSetId) {
			super(predefinedTrust, actionSetId);
		}
	
		@Override
		public List<AtomicAction> build(DocumentToResearchInitiatives object,
				Agent agent) {
			Oaf oaf = buildOAFResearchInitiativeConcepts(object);
			if (oaf!=null) {
				return actionFactory.createUpdateActions(
						actionSetId,
						agent, object.getDocumentId().toString(), Type.result, 
						oaf.toByteArray());	
			} else {
				return Collections.emptyList();
			}
		}
		
		/**
		 * Builds OAF object containing research initiative concepts.
		 * @param source
		 * @return OAF object containing research initiative concepts
		 */
		protected Oaf buildOAFResearchInitiativeConcepts(DocumentToResearchInitiatives source) {
			if (source.getResearchInitiativeConceptIds()!=null && 
					source.getResearchInitiativeConceptIds().size()>0) {
				eu.dnetlib.data.proto.ResultProtos.Result.Metadata.Builder metaBuilder = Metadata.newBuilder();
				List<Context> contexts = new ArrayList<Context>(
						source.getResearchInitiativeConceptIds().size());
				for (CharSequence riConceptId : source.getResearchInitiativeConceptIds()) {
					Context.Builder contextBuilder = Context.newBuilder();
					contextBuilder.setId(riConceptId.toString());
					contexts.add(contextBuilder.build());
				}
				metaBuilder.addAllContext(contexts);
				eu.dnetlib.data.proto.ResultProtos.Result.Builder resultBuilder = Result.newBuilder();
				resultBuilder.setMetadata(metaBuilder.build());
	
				eu.dnetlib.data.proto.OafProtos.OafEntity.Builder entityBuilder = OafEntity.newBuilder();
				if (source.getDocumentId()!=null) {
					entityBuilder.setId(source.getDocumentId().toString());	
				}
				entityBuilder.setType(Type.result);
				entityBuilder.setResult(resultBuilder.build());	
				return buildOaf(entityBuilder.build());
			}
//			fallback
			return null;
		}

	}
	
	@Override
	public AlgorithmName getAlgorithName() {
		return AlgorithmName.document_research_initiative;
	}

	@Override
	public ActionBuilderModule<DocumentToResearchInitiatives> instantiate(
			String predefinedTrust, String actionSetId) {
		return new DocumentToResearchInitiativesActionBuilderModule(
				predefinedTrust, actionSetId);
	}
}
