package eu.dnetlib.iis.export.actionmanager.module;

import java.util.Arrays;
import java.util.List;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.KindProtos.Kind;
import eu.dnetlib.data.proto.OafProtos.Oaf;
import eu.dnetlib.data.proto.OafProtos.OafRel;
import eu.dnetlib.data.proto.RelTypeProtos.RelType;
import eu.dnetlib.data.proto.SimilarityRelProtos.SimilarityRel;
import eu.dnetlib.iis.websiteusage.schemas.DocumentsWithWebsiteUsageSimilarities;

/**
 * {@link DocumentsWithWebsiteUsageSimilarities} based action builder module.
 * @author mhorst
 *
 */
public class DocumentsWithWebsiteUsageSimilaritiesActionBuilderModuleFactory 
	implements ActionBuilderFactory<DocumentsWithWebsiteUsageSimilarities> {

	class DocumentsWithWebsiteUsageSimilaritiesActionBuilder extends
	AbstractBuilderModule implements ActionBuilderModule<DocumentsWithWebsiteUsageSimilarities> {
	
		/**
		 * Default similarity level.
		 */
		private final float defaultSimilarityLevel = 0;
		
		private final RelType relTypeSimilarity = RelType.similarityRel;
		
		/**
		 * Default constructor.
		 * @param predefinedTrust
		 * @param actionSetId
		 */
		public DocumentsWithWebsiteUsageSimilaritiesActionBuilder(
				String predefinedTrust, String actionSetId) {
			super(predefinedTrust, actionSetId);
		}
	
		@Override
		public List<AtomicAction> build(
				DocumentsWithWebsiteUsageSimilarities object, Agent agent) {
			String currentSimDocId = object.getOtherDocumentId().toString();
			String docId = object.getDocumentId().toString();
			return Arrays.asList(new AtomicAction[] {
					actionFactory.createAtomicAction(
						actionSetId, agent, docId, 
						relTypeSimilarity.name(), 
						currentSimDocId, 
						buildSimilarityRel(docId, currentSimDocId,
								object.getCovisitedSimilarity()!=null?
										object.getCovisitedSimilarity():
											defaultSimilarityLevel).toByteArray()),
	//		adding reverse relation
					actionFactory.createAtomicAction(
							actionSetId, agent, currentSimDocId,  
						relTypeSimilarity.name(), 
						docId,
						buildSimilarityRel(currentSimDocId, docId,
								object.getCovisitedSimilarity()!=null?
										object.getCovisitedSimilarity():
											defaultSimilarityLevel).toByteArray())
			});
		}
	
		/**
		 * Builds OAF object.
		 * @param source
		 * @param target
		 * @param score
		 * @return OAF object
		 */
		private Oaf buildSimilarityRel(String source, String target, float score) {
			OafRel.Builder relBuilder = OafRel.newBuilder();
			relBuilder.setSource(source);
			relBuilder.setTarget(target);
			relBuilder.setChild(false);
			relBuilder.setRelType(relTypeSimilarity);
			relBuilder.setSimilarityRel(
					SimilarityRel.newBuilder().setType(
							SimilarityRel.Type.WEBUSAGE).setSimilarity(
							score).build());
			eu.dnetlib.data.proto.OafProtos.Oaf.Builder oafBuilder = Oaf.newBuilder();
			oafBuilder.setKind(Kind.relation);
			oafBuilder.setRel(relBuilder.build());
			oafBuilder.setDataInfo(buildInference());
			oafBuilder.setTimestamp(System.currentTimeMillis());
			return oafBuilder.build();
		}

	}
	
	@Override
	public AlgorithmName getAlgorithName() {
		return AlgorithmName.document_similarities_websiteusage;
	}

	@Override
	public ActionBuilderModule<DocumentsWithWebsiteUsageSimilarities> instantiate(
			String predefinedTrust, String actionSetId) {
		return new DocumentsWithWebsiteUsageSimilaritiesActionBuilder(
				predefinedTrust, actionSetId);
	}
}
