/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.data.proto.SpecialTrustProtos;
import eu.dnetlib.iis.export.actionmanager.api.ActionManagerServiceFacade;
import eu.dnetlib.iis.export.actionmanager.cfg.ActionManagerConfigurationProvider;
import eu.dnetlib.iis.export.actionmanager.cfg.StaticConfigurationProvider;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderFactory;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.ActionSetIdProvider;
import eu.dnetlib.iis.export.actionmanager.module.ActionSetMappingNotDefinedException;
import eu.dnetlib.iis.export.actionmanager.module.AlgorithmName;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;

public abstract class AbstractActionManagerBasedExporterMapper
extends Mapper<AvroKey<? extends SpecificRecordBase>, NullWritable, NullWritable, NullWritable> {
    private String predefinedTrust = SpecialTrustProtos.SpecialTrust.NEUTRAL.name();
    private ActionManagerServiceFacade actionManager;
    private ActionManagerConfigurationProvider configProvider;
    private ActionBuilderModule<SpecificRecordBase> actionBuilder;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        String moduleClassName;
        if (context.getConfiguration().get("export.trust.level") != null) {
            this.predefinedTrust = context.getConfiguration().get("export.trust.level");
        }
        boolean skipOriginalMetadata = true;
        if (context.getConfiguration().get("export.skip.original.metadata") != null) {
            skipOriginalMetadata = Boolean.valueOf(context.getConfiguration().get("export.skip.original.metadata"));
        }
        boolean skipExportingAuthors = true;
        if (context.getConfiguration().get("export.skip.authors") != null) {
            skipExportingAuthors = Boolean.valueOf(context.getConfiguration().get("export.skip.authors"));
        }
        if ((moduleClassName = context.getConfiguration().get("export.action.builder.factory.classname")) != null) {
            try {
                ActionSetIdProvider actionSetIdProvider = this.provideAlgorithmToActionSetMap(context);
                Class<?> clazz = Class.forName(moduleClassName);
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                ActionBuilderFactory actionBuilderFactory = (ActionBuilderFactory)constructor.newInstance(new Object[0]);
                this.actionBuilder = actionBuilderFactory.instantiate(this.predefinedTrust, actionSetIdProvider.getActionSetId(actionBuilderFactory.getAlgorithName()));
                this.actionManager = this.buildActionManager(context);
                this.configProvider = new StaticConfigurationProvider(StaticConfigurationProvider.AGENT_DEFAULT, StaticConfigurationProvider.PROVENANCE_DEFAULT, "0.9", "iis");
            }
            catch (Exception e) {
                throw new RuntimeException("unexpected exception ocurred when instantiating builder module: " + moduleClassName, e);
            }
        } else {
            throw new RuntimeException("unknown action builder module instance, no export.action.builder.factory.classname parameter provided!");
        }
    }

    private ActionSetIdProvider provideAlgorithmToActionSetMap(Mapper.Context context) {
        String defaultActionSetId = null;
        if (context.getConfiguration().get("export.action.setid") != null && !"$UNDEFINED$".equals(context.getConfiguration().get("export.action.setid"))) {
            defaultActionSetId = context.getConfiguration().get("export.action.setid");
        }
        final HashMap<AlgorithmName, String> algoToActionSetMap = new HashMap<AlgorithmName, String>();
        for (AlgorithmName currentAlgorithm : AlgorithmName.values()) {
            String propertyKey = "export.action.setid." + currentAlgorithm.name();
            if (context.getConfiguration().get(propertyKey) != null && !"$UNDEFINED$".equals(context.getConfiguration().get(propertyKey))) {
                algoToActionSetMap.put(currentAlgorithm, context.getConfiguration().get(propertyKey));
                continue;
            }
            algoToActionSetMap.put(currentAlgorithm, defaultActionSetId);
        }
        return new ActionSetIdProvider(){

            @Override
            public String getActionSetId(AlgorithmName algorithmName) throws ActionSetMappingNotDefinedException {
                String actionSetId = (String)algoToActionSetMap.get((Object)algorithmName);
                if (actionSetId != null && !"$UNDEFINED$".equals(actionSetId)) {
                    return actionSetId;
                }
                throw new ActionSetMappingNotDefinedException("no action set identifier defined for algorithm: " + algorithmName.name());
            }
        };
    }

    protected abstract ActionManagerServiceFacade buildActionManager(Mapper.Context var1) throws IOException;

    protected List<AtomicAction> createActions(SpecificRecordBase datum) {
        return this.actionBuilder.build(datum, this.configProvider.provideAgent());
    }

    protected void map(AvroKey<? extends SpecificRecordBase> key, NullWritable ignore, Mapper.Context context) throws IOException, InterruptedException {
        try {
            List<AtomicAction> actions = this.createActions((SpecificRecordBase)key.datum());
            if (actions != null) {
                this.actionManager.storeAction(actions, null, null, this.configProvider.provideNamespacePrefix());
            }
        }
        catch (ActionManagerException e) {
            throw new RuntimeException(e);
        }
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        try {
            if (this.actionManager != null) {
                this.actionManager.close();
            }
        }
        catch (ActionManagerException e) {
            throw new IOException(e);
        }
        finally {
            super.cleanup(context);
        }
    }
}

