/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager;

import com.google.common.collect.Sets;
import eu.dnetlib.actionmanager.ActionManagerConstants;
import eu.dnetlib.iis.core.java.HadoopContext;
import eu.dnetlib.iis.core.java.PortBindings;
import eu.dnetlib.iis.core.java.Process;
import eu.dnetlib.iis.core.java.ProcessUtils;
import eu.dnetlib.iis.core.java.porttype.PortType;
import eu.dnetlib.iis.export.actionmanager.api.HBaseActionManagerServiceFacade;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.log4j.Logger;

public class TableCreatorProcess
implements Process {
    private final Logger log = Logger.getLogger(this.getClass());

    public Map<String, PortType> getInputPorts() {
        return Collections.emptyMap();
    }

    public Map<String, PortType> getOutputPorts() {
        return Collections.emptyMap();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(PortBindings portBindings, HadoopContext context, Map<String, String> parameters) throws Exception {
        String initializeTable = ProcessUtils.getParameterValue((String)"export.action.hbase.table.initialize", (Configuration)context.getConfiguration(), parameters);
        if (initializeTable != null && !initializeTable.isEmpty() && Boolean.parseBoolean(initializeTable)) {
            String hBaseTableName = ProcessUtils.getParameterValue((String)"export.action.hbase.table.name", (Configuration)context.getConfiguration(), parameters);
            if (hBaseTableName == null) throw new RuntimeException("no action manager hbase table name provided!");
            this.prepareTable(false, hBaseTableName, HBaseActionManagerServiceFacade.buildHBaseConfiguration(context.getConfiguration(), parameters));
            return;
        } else {
            this.log.warn((Object)"skipping table initialization");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareTable(boolean delete, String tableName, Configuration config) throws IOException {
        HBaseAdmin admin = new HBaseAdmin(config);
        try {
            if (delete && admin.tableExists(tableName)) {
                this.log.info((Object)("Deleting existing hbase table: " + tableName));
                admin.disableTable(tableName);
                admin.deleteTable(tableName);
            }
            if (!admin.tableExists(tableName)) {
                this.log.info((Object)("Creating missing hbase table: " + tableName));
                admin.createTable(new HTableDescriptor(tableName));
            }
            HTableDescriptor desc = admin.getTableDescriptor(Bytes.toBytes((String)tableName));
            HashSet currents = Sets.newHashSet();
            for (HColumnDescriptor hcd : desc.getColumnFamilies()) {
                currents.add(hcd.getNameAsString());
            }
            HashSet missing = Sets.newHashSet();
            for (ActionManagerConstants.COLUMN_FAMILIES cf : ActionManagerConstants.COLUMN_FAMILIES.values()) {
                if (currents.contains(cf.toString())) continue;
                missing.add(cf.toString());
            }
            if (!missing.isEmpty()) {
                if (admin.isTableEnabled(tableName)) {
                    admin.disableTable(tableName);
                }
                for (String column : missing) {
                    this.log.info((Object)("hbase table: '" + tableName + "', adding columnFamily: " + column));
                    admin.addColumn(tableName, new HColumnDescriptor(column));
                }
                admin.enableTable(tableName);
            }
        }
        finally {
            admin.close();
        }
    }
}

