/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.api;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.actions.XsltInfoPackageAction;
import eu.dnetlib.actionmanager.common.Provenance;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.iis.core.java.ProcessUtils;
import eu.dnetlib.iis.export.actionmanager.api.ActionManagerServiceFacade;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Put;

public class HBaseActionManagerServiceFacade
implements ActionManagerServiceFacade {
    private final HTableInterface hTable;
    private List<Put> putCache = new ArrayList<Put>();
    private int cacheThreshold = 1000;

    public HBaseActionManagerServiceFacade(Configuration config) throws IOException {
        this(config, Collections.emptyMap());
    }

    public HBaseActionManagerServiceFacade(Configuration hadoopConf, Map<String, String> parameters) throws IOException {
        String hBaseTableName = ProcessUtils.getParameterValue((String)"export.action.hbase.table.name", (Configuration)hadoopConf, parameters);
        if (hBaseTableName == null) {
            throw new RuntimeException("no action manager hbase table name provided!");
        }
        this.hTable = new HTable(HBaseActionManagerServiceFacade.buildHBaseConfiguration(hadoopConf, parameters), hBaseTableName);
    }

    public static Configuration buildHBaseConfiguration(Configuration hadoopConf, Map<String, String> parameters) {
        Configuration hbaseConfiguration = HBaseConfiguration.create((Configuration)hadoopConf);
        String zookeeperQuorum = ProcessUtils.getParameterValue((String)"export.action.hbase.remote.zookeeper.quorum", (Configuration)hadoopConf, parameters);
        if (zookeeperQuorum != null && !zookeeperQuorum.trim().isEmpty() && !zookeeperQuorum.trim().equals("$UNDEFINED$")) {
            hbaseConfiguration.set("hbase.zookeeper.quorum", zookeeperQuorum.trim());
            String zookeeperClientPort = ProcessUtils.getParameterValue((String)"export.action.hbase.remote.zookeeper.clientport", (Configuration)hadoopConf, parameters);
            if (zookeeperClientPort != null && !zookeeperClientPort.trim().isEmpty() && !zookeeperClientPort.trim().equals("$UNDEFINED$")) {
                hbaseConfiguration.set("hbase.zookeeper.property.clientPort", zookeeperClientPort.trim());
            }
        }
        return hbaseConfiguration;
    }

    @Override
    public void storeAction(Collection<AtomicAction> actions, Provenance provenance, String trust, String nsprefix) throws ActionManagerException {
        if (actions != null) {
            for (AtomicAction action : actions) {
                this.putCache.addAll(action.asPutOperations(null, provenance, trust, nsprefix));
            }
            if (this.putCache.size() > this.cacheThreshold) {
                try {
                    this.hTable.put(this.putCache);
                    this.putCache.clear();
                }
                catch (IOException e) {
                    throw new ActionManagerException((Throwable)e);
                }
            }
        }
    }

    @Override
    public void storeAction(XsltInfoPackageAction action, Provenance provenance, String trust, String nsprefix) throws ActionManagerException {
        if (action != null) {
            this.putCache.addAll(action.asPutOperations(null, provenance, trust, nsprefix));
            if (this.putCache.size() > this.cacheThreshold) {
                try {
                    this.hTable.put(this.putCache);
                    this.putCache.clear();
                }
                catch (IOException e) {
                    throw new ActionManagerException((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws ActionManagerException {
        block10: {
            if (this.hTable != null) {
                try {
                    if (this.putCache.isEmpty()) break block10;
                    try {
                        this.hTable.put(this.putCache);
                        this.putCache.clear();
                    }
                    catch (IOException e) {
                        throw new ActionManagerException((Throwable)e);
                    }
                }
                finally {
                    try {
                        this.hTable.flushCommits();
                        this.hTable.close();
                    }
                    catch (IOException e) {
                        throw new ActionManagerException((Throwable)e);
                    }
                }
            }
        }
    }

    public void setCacheThreshold(int cacheThreshold) {
        this.cacheThreshold = cacheThreshold;
    }
}

