/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.module;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.AuthorStatisticsProto;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.PersonProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.iis.export.actionmanager.convert.AvroToProtobufConverter;
import eu.dnetlib.iis.export.actionmanager.module.AbstractBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderFactory;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.AlgorithmName;
import eu.dnetlib.iis.statistics.schemas.AuthorToAuthorStatistics;
import java.util.Collections;
import java.util.List;

public class AuthorToAuthorStatisticsActionBuilderModuleFactory
implements ActionBuilderFactory<AuthorToAuthorStatistics> {
    @Override
    public AlgorithmName getAlgorithName() {
        return AlgorithmName.person_statistics;
    }

    @Override
    public ActionBuilderModule<AuthorToAuthorStatistics> instantiate(String predefinedTrust, String actionSetId) {
        return new AuthorToAuthorStatisticsActionBuilderModule(predefinedTrust, actionSetId);
    }

    class AuthorToAuthorStatisticsActionBuilderModule
    extends AbstractBuilderModule
    implements ActionBuilderModule<AuthorToAuthorStatistics> {
        private AuthorToAuthorStatisticsActionBuilderModule(String predefinedTrust, String actionSetId) {
            super(predefinedTrust, actionSetId);
        }

        @Override
        public List<AtomicAction> build(AuthorToAuthorStatistics object, Agent agent) {
            OafProtos.Oaf oafObject = this.buildOAF(object);
            if (oafObject != null) {
                return this.actionFactory.createUpdateActions(this.actionSetId, agent, object.getAuthorId().toString(), TypeProtos.Type.person, oafObject.toByteArray());
            }
            return Collections.emptyList();
        }

        protected OafProtos.Oaf buildOAF(AuthorToAuthorStatistics source) {
            PersonProtos.Person person = this.buildPersonStatistics(source);
            if (person != null) {
                OafProtos.OafEntity.Builder entityBuilder = OafProtos.OafEntity.newBuilder();
                if (source.getAuthorId() != null) {
                    entityBuilder.setId(source.getAuthorId().toString());
                }
                entityBuilder.setPerson(person);
                entityBuilder.setType(TypeProtos.Type.person);
                return this.buildOaf(entityBuilder.build());
            }
            return null;
        }

        protected PersonProtos.Person buildPersonStatistics(AuthorToAuthorStatistics source) {
            AuthorStatisticsProto.AuthorStatistics convertedStatistics;
            if (source.getStatistics() != null && (convertedStatistics = AvroToProtobufConverter.convertAvroToProtoBuff(source.getStatistics())) != null) {
                PersonProtos.Person.Builder personBuilder = PersonProtos.Person.newBuilder();
                personBuilder.setStatistics(convertedStatistics);
                return personBuilder.build();
            }
            return null;
        }
    }
}

