/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.module;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.SimilarityRelProtos;
import eu.dnetlib.iis.documentssimilarity.schemas.DocumentSimilarity;
import eu.dnetlib.iis.export.actionmanager.module.AbstractBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderFactory;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.AlgorithmName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DocumentSimilarityActionBuilderModuleFactory
implements ActionBuilderFactory<DocumentSimilarity> {
    @Override
    public AlgorithmName getAlgorithName() {
        return AlgorithmName.document_similarities_standard;
    }

    @Override
    public ActionBuilderModule<DocumentSimilarity> instantiate(String predefinedTrust, String actionSetId) {
        return new DocumentSimilarityActionBuilderModule(predefinedTrust, actionSetId);
    }

    class DocumentSimilarityActionBuilderModule
    extends AbstractBuilderModule
    implements ActionBuilderModule<DocumentSimilarity> {
        public DocumentSimilarityActionBuilderModule(String predefinedTrust, String actionSetId) {
            super(predefinedTrust, actionSetId);
        }

        @Override
        public List<AtomicAction> build(DocumentSimilarity object, Agent agent) {
            if (object == null) {
                return Collections.emptyList();
            }
            List<AtomicAction> simActions = this.createActions(object, this.actionSetId, agent, false);
            List<AtomicAction> reverseSimActions = this.createActions(object, this.actionSetId, agent, true);
            ArrayList<AtomicAction> results = new ArrayList<AtomicAction>();
            if (simActions != null && !simActions.isEmpty()) {
                results.addAll(simActions);
            }
            if (reverseSimActions != null && !reverseSimActions.isEmpty()) {
                results.addAll(reverseSimActions);
            }
            return results;
        }

        protected List<AtomicAction> createActions(DocumentSimilarity object, String actionSet, Agent agent, boolean backwardMode) {
            OafProtos.Oaf oafObjectRel = this.buildOAFRel(object.getDocumentId().toString(), object.getOtherDocumentId().toString(), object.getSimilarity().floatValue(), backwardMode);
            if (oafObjectRel == null) {
                return Collections.emptyList();
            }
            ArrayList<AtomicAction> actionList = new ArrayList<AtomicAction>();
            AtomicAction currentAction = this.actionFactory.createAtomicAction(actionSet, agent, backwardMode ? object.getOtherDocumentId().toString() : object.getDocumentId().toString(), RelTypeProtos.RelType.similarityRel.name(), backwardMode ? object.getDocumentId().toString() : object.getOtherDocumentId().toString(), oafObjectRel.toByteArray());
            actionList.add(currentAction);
            return actionList;
        }

        private OafProtos.Oaf buildOAFRel(String sourceId, String targetDocId, float score, boolean invert) {
            OafProtos.OafRel.Builder relBuilder = OafProtos.OafRel.newBuilder();
            if (!invert) {
                relBuilder.setSource(sourceId);
                relBuilder.setTarget(targetDocId);
            } else {
                relBuilder.setSource(targetDocId);
                relBuilder.setTarget(sourceId);
            }
            relBuilder.setChild(false);
            relBuilder.setRelType(RelTypeProtos.RelType.similarityRel);
            relBuilder.setSimilarityRel(SimilarityRelProtos.SimilarityRel.newBuilder().setType(SimilarityRelProtos.SimilarityRel.Type.STANDARD).setSimilarity(score).build());
            OafProtos.Oaf.Builder oafBuilder = OafProtos.Oaf.newBuilder();
            oafBuilder.setKind(KindProtos.Kind.relation);
            oafBuilder.setRel(relBuilder.build());
            oafBuilder.setDataInfo(this.buildInference());
            oafBuilder.setTimestamp(System.currentTimeMillis());
            return oafBuilder.build();
        }
    }
}

