/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.module;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.ResultResultProtos;
import eu.dnetlib.iis.export.actionmanager.module.AbstractBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderFactory;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.AlgorithmName;
import eu.dnetlib.iis.referenceextraction.dataset.schemas.DocumentToDataSet;
import java.util.Arrays;
import java.util.List;

public class DocumentToDataSetActionBuilderModuleFactory
implements ActionBuilderFactory<DocumentToDataSet> {
    @Override
    public AlgorithmName getAlgorithName() {
        return AlgorithmName.document_referencedDatasets;
    }

    @Override
    public ActionBuilderModule<DocumentToDataSet> instantiate(String predefinedTrust, String actionSetId) {
        return new DocumentToDataSetActionBuilderModule(predefinedTrust, actionSetId);
    }

    class DocumentToDataSetActionBuilderModule
    extends AbstractBuilderModule
    implements ActionBuilderModule<DocumentToDataSet> {
        private final RelTypeProtos.RelType relTypeResultResult;

        public DocumentToDataSetActionBuilderModule(String predefinedTrust, String actionSetId) {
            super(predefinedTrust, actionSetId);
            this.relTypeResultResult = RelTypeProtos.RelType.resultResult;
        }

        @Override
        public List<AtomicAction> build(DocumentToDataSet object, Agent agent) {
            String docId = object.getDocumentId().toString();
            String currentRefId = object.getDatasetId().toString();
            OafProtos.Oaf.Builder oafBuilder = OafProtos.Oaf.newBuilder();
            oafBuilder.setKind(KindProtos.Kind.relation);
            OafProtos.OafRel.Builder relBuilder = OafProtos.OafRel.newBuilder();
            relBuilder.setChild(false);
            relBuilder.setRelType(this.relTypeResultResult);
            relBuilder.setSource(docId);
            relBuilder.setTarget(currentRefId);
            ResultResultProtos.ResultResult.Builder resResultBuilder = ResultResultProtos.ResultResult.newBuilder();
            resResultBuilder.setRelMetadata(this.buildRelMetadata("dnet:result_result_relations", "isRelatedTo"));
            relBuilder.setResultResult(resResultBuilder.build());
            oafBuilder.setRel(relBuilder.build());
            oafBuilder.setDataInfo(this.buildInference());
            oafBuilder.setTimestamp(System.currentTimeMillis());
            return Arrays.asList(this.actionFactory.createAtomicAction(this.actionSetId, agent, docId, this.relTypeResultResult.name(), currentRefId, oafBuilder.build().toByteArray()), this.actionFactory.createAtomicAction(this.actionSetId, agent, currentRefId, this.relTypeResultResult.name(), docId, DocumentToDataSetActionBuilderModule.invertRelationAndBuild(oafBuilder)));
        }
    }
}

