/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.module;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.DocumentClassesProto;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.iis.documentsclassification.schemas.DocumentToDocumentClasses;
import eu.dnetlib.iis.export.actionmanager.convert.AvroToProtobufConverter;
import eu.dnetlib.iis.export.actionmanager.module.AbstractBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderFactory;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.AlgorithmName;
import java.util.Collections;
import java.util.List;

public class DocumentToDocumentClassesActionBuilderModuleFactory
implements ActionBuilderFactory<DocumentToDocumentClasses> {
    @Override
    public AlgorithmName getAlgorithName() {
        return AlgorithmName.document_classes;
    }

    @Override
    public ActionBuilderModule<DocumentToDocumentClasses> instantiate(String predefinedTrust, String actionSetId) {
        return new DocumentToDocumentClassesActionBuilderModule(predefinedTrust, actionSetId);
    }

    class DocumentToDocumentClassesActionBuilderModule
    extends AbstractBuilderModule
    implements ActionBuilderModule<DocumentToDocumentClasses> {
        public DocumentToDocumentClassesActionBuilderModule(String predefinedTrust, String actionSetId) {
            super(predefinedTrust, actionSetId);
        }

        @Override
        public List<AtomicAction> build(DocumentToDocumentClasses object, Agent agent) {
            OafProtos.Oaf oaf = this.buildOAFClasses(object);
            if (oaf != null) {
                return this.actionFactory.createUpdateActions(this.actionSetId, agent, object.getDocumentId().toString(), TypeProtos.Type.result, oaf.toByteArray());
            }
            return Collections.emptyList();
        }

        protected OafProtos.Oaf buildOAFClasses(DocumentToDocumentClasses source) {
            if (source.getClasses() != null) {
                ResultProtos.Result.Builder resultBuilder = ResultProtos.Result.newBuilder();
                DocumentClassesProto.DocumentClasses docClasses = AvroToProtobufConverter.convertAvroToProtoBuff(source.getClasses());
                if (docClasses != null) {
                    resultBuilder.setDocumentClasses(docClasses);
                    OafProtos.OafEntity.Builder entityBuilder = OafProtos.OafEntity.newBuilder();
                    if (source.getDocumentId() != null) {
                        entityBuilder.setId(source.getDocumentId().toString());
                    }
                    entityBuilder.setType(TypeProtos.Type.result);
                    entityBuilder.setResult(resultBuilder.build());
                    return this.buildOaf(entityBuilder.build());
                }
            }
            return null;
        }
    }
}

