/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.module;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.DocumentStatisticsProto;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.iis.export.actionmanager.convert.AvroToProtobufConverter;
import eu.dnetlib.iis.export.actionmanager.module.AbstractBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderFactory;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.AlgorithmName;
import eu.dnetlib.iis.statistics.schemas.DocumentToDocumentStatistics;
import java.util.Collections;
import java.util.List;

public class DocumentToDocumentStatisticsActionBuilderModuleFactory
implements ActionBuilderFactory<DocumentToDocumentStatistics> {
    @Override
    public AlgorithmName getAlgorithName() {
        return AlgorithmName.document_statistics;
    }

    @Override
    public ActionBuilderModule<DocumentToDocumentStatistics> instantiate(String predefinedTrust, String actionSetId) {
        return new DocumentToDocumentStatisticsActionBuilderModule(predefinedTrust, actionSetId);
    }

    class DocumentToDocumentStatisticsActionBuilderModule
    extends AbstractBuilderModule
    implements ActionBuilderModule<DocumentToDocumentStatistics> {
        public DocumentToDocumentStatisticsActionBuilderModule(String predefinedTrust, String actionSetId) {
            super(predefinedTrust, actionSetId);
        }

        @Override
        public List<AtomicAction> build(DocumentToDocumentStatistics object, Agent agent) {
            OafProtos.Oaf oaf = this.buildOAFStatistics(object);
            if (oaf != null) {
                return this.actionFactory.createUpdateActions(this.actionSetId, agent, object.getDocumentId().toString(), TypeProtos.Type.result, oaf.toByteArray());
            }
            return Collections.emptyList();
        }

        protected OafProtos.Oaf buildOAFStatistics(DocumentToDocumentStatistics source) {
            if (source.getStatistics() != null) {
                ResultProtos.Result.Builder resultBuilder = ResultProtos.Result.newBuilder();
                DocumentStatisticsProto.DocumentStatistics docStatistics = AvroToProtobufConverter.convertAvroToProtoBuff(source.getStatistics());
                if (docStatistics != null) {
                    resultBuilder.setStatistics(docStatistics);
                    OafProtos.OafEntity.Builder entityBuilder = OafProtos.OafEntity.newBuilder();
                    if (source.getDocumentId() != null) {
                        entityBuilder.setId(source.getDocumentId().toString());
                    }
                    entityBuilder.setType(TypeProtos.Type.result);
                    entityBuilder.setResult(resultBuilder.build());
                    return this.buildOaf(entityBuilder.build());
                }
            }
            return null;
        }
    }
}

