/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.module;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.ResultProjectProtos;
import eu.dnetlib.iis.export.actionmanager.module.AbstractBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderFactory;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.AlgorithmName;
import eu.dnetlib.iis.referenceextraction.project.schemas.DocumentToProject;
import java.util.Arrays;
import java.util.List;

public class DocumentToProjectActionBuilderModuleFactory
implements ActionBuilderFactory<DocumentToProject> {
    @Override
    public AlgorithmName getAlgorithName() {
        return AlgorithmName.document_referencedProjects;
    }

    @Override
    public ActionBuilderModule<DocumentToProject> instantiate(String predefinedTrust, String actionSetId) {
        return new DocumentToProjectActionBuilderModule(predefinedTrust, actionSetId);
    }

    class DocumentToProjectActionBuilderModule
    extends AbstractBuilderModule
    implements ActionBuilderModule<DocumentToProject> {
        private final RelTypeProtos.RelType relTypeResultProject;

        public DocumentToProjectActionBuilderModule(String predefinedTrust, String actionSetId) {
            super(predefinedTrust, actionSetId);
            this.relTypeResultProject = RelTypeProtos.RelType.resultProject;
        }

        @Override
        public List<AtomicAction> build(DocumentToProject object, Agent agent) {
            String docId = object.getDocumentId().toString();
            String currentProjectIdStr = object.getProjectId().toString();
            OafProtos.Oaf.Builder oafBuilder = OafProtos.Oaf.newBuilder();
            oafBuilder.setKind(KindProtos.Kind.relation);
            OafProtos.OafRel.Builder relBuilder = OafProtos.OafRel.newBuilder();
            relBuilder.setChild(false);
            relBuilder.setRelType(this.relTypeResultProject);
            relBuilder.setSource(docId);
            relBuilder.setTarget(currentProjectIdStr);
            ResultProjectProtos.ResultProject.Builder resProjBuilder = ResultProjectProtos.ResultProject.newBuilder();
            resProjBuilder.setRelMetadata(this.buildRelMetadata("dnet:result_project_relations", "isResultOf"));
            relBuilder.setResultProject(resProjBuilder.build());
            oafBuilder.setRel(relBuilder.build());
            oafBuilder.setDataInfo(this.buildInference());
            oafBuilder.setTimestamp(System.currentTimeMillis());
            return Arrays.asList(this.actionFactory.createAtomicAction(this.actionSetId, agent, docId, this.relTypeResultProject.name(), currentProjectIdStr, oafBuilder.build().toByteArray()), this.actionFactory.createAtomicAction(this.actionSetId, agent, currentProjectIdStr, this.relTypeResultProject.name(), docId, DocumentToProjectActionBuilderModule.invertRelationAndBuild(oafBuilder)));
        }
    }
}

