/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.module;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.iis.export.actionmanager.module.AbstractBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderFactory;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.AlgorithmName;
import eu.dnetlib.iis.export.schemas.DocumentToResearchInitiatives;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DocumentToResearchInitiativesActionBuilderModuleFactory
implements ActionBuilderFactory<DocumentToResearchInitiatives> {
    @Override
    public AlgorithmName getAlgorithName() {
        return AlgorithmName.document_research_initiative;
    }

    @Override
    public ActionBuilderModule<DocumentToResearchInitiatives> instantiate(String predefinedTrust, String actionSetId) {
        return new DocumentToResearchInitiativesActionBuilderModule(predefinedTrust, actionSetId);
    }

    class DocumentToResearchInitiativesActionBuilderModule
    extends AbstractBuilderModule
    implements ActionBuilderModule<DocumentToResearchInitiatives> {
        public DocumentToResearchInitiativesActionBuilderModule(String predefinedTrust, String actionSetId) {
            super(predefinedTrust, actionSetId);
        }

        @Override
        public List<AtomicAction> build(DocumentToResearchInitiatives object, Agent agent) {
            OafProtos.Oaf oaf = this.buildOAFResearchInitiativeConcepts(object);
            if (oaf != null) {
                return this.actionFactory.createUpdateActions(this.actionSetId, agent, object.getDocumentId().toString(), TypeProtos.Type.result, oaf.toByteArray());
            }
            return Collections.emptyList();
        }

        protected OafProtos.Oaf buildOAFResearchInitiativeConcepts(DocumentToResearchInitiatives source) {
            if (source.getResearchInitiativeConceptIds() != null && source.getResearchInitiativeConceptIds().size() > 0) {
                ResultProtos.Result.Metadata.Builder metaBuilder = ResultProtos.Result.Metadata.newBuilder();
                ArrayList<ResultProtos.Result.Context> contexts = new ArrayList<ResultProtos.Result.Context>(source.getResearchInitiativeConceptIds().size());
                for (CharSequence riConceptId : source.getResearchInitiativeConceptIds()) {
                    ResultProtos.Result.Context.Builder contextBuilder = ResultProtos.Result.Context.newBuilder();
                    contextBuilder.setId(riConceptId.toString());
                    contexts.add(contextBuilder.build());
                }
                metaBuilder.addAllContext(contexts);
                ResultProtos.Result.Builder resultBuilder = ResultProtos.Result.newBuilder();
                resultBuilder.setMetadata(metaBuilder.build());
                OafProtos.OafEntity.Builder entityBuilder = OafProtos.OafEntity.newBuilder();
                if (source.getDocumentId() != null) {
                    entityBuilder.setId(source.getDocumentId().toString());
                }
                entityBuilder.setType(TypeProtos.Type.result);
                entityBuilder.setResult(resultBuilder.build());
                return this.buildOaf(entityBuilder.build());
            }
            return null;
        }
    }
}

