/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.module;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.PersonResultProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.iis.export.actionmanager.module.AbstractBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderFactory;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.AlgorithmName;
import eu.dnetlib.iis.export.schemas.DocumentWithInferencedData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DocumentWithInferencedDataActionBuilderModuleFactory
implements ActionBuilderFactory<DocumentWithInferencedData> {
    @Override
    public AlgorithmName getAlgorithName() {
        return null;
    }

    @Override
    public ActionBuilderModule<DocumentWithInferencedData> instantiate(String predefinedTrust, String actionSetId) {
        return new DocumentWithInferencedDataActionBuilderModule(predefinedTrust, actionSetId);
    }

    class DocumentWithInferencedDataActionBuilderModule
    extends AbstractBuilderModule
    implements ActionBuilderModule<DocumentWithInferencedData> {
        public DocumentWithInferencedDataActionBuilderModule(String predefinedTrust, String actionSetId) {
            super(predefinedTrust, actionSetId);
        }

        @Override
        public List<AtomicAction> build(DocumentWithInferencedData object, Agent agent) {
            if (object == null) {
                return null;
            }
            if (object.getId() == null) {
                throw new RuntimeException("unable to process object with null identifier");
            }
            try {
                return this.handleReferencedAuthors(agent, object.getAuthorIds(), object.getId().toString());
            }
            catch (IOException e1) {
                throw new RuntimeException(e1);
            }
        }

        private List<AtomicAction> handleReferencedAuthors(Agent agent, List<CharSequence> authorIds, String docId) throws IOException {
            if (authorIds != null && authorIds.size() > 0) {
                ArrayList<AtomicAction> actions = new ArrayList<AtomicAction>();
                RelTypeProtos.RelType relTypePersonResult = RelTypeProtos.RelType.personResult;
                for (CharSequence authorId : authorIds) {
                    String authorIdStr = authorId.toString();
                    PersonResultProtos.PersonResult.Builder authResultBuilder = PersonResultProtos.PersonResult.newBuilder();
                    authResultBuilder.setRelMetadata(this.buildRelMetadata("dnet:personroles", "author"));
                    OafProtos.OafRel.Builder relBuilder = OafProtos.OafRel.newBuilder();
                    relBuilder.setSource(docId);
                    relBuilder.setTarget(authorIdStr);
                    relBuilder.setRelType(relTypePersonResult);
                    relBuilder.setChild(false);
                    relBuilder.setPersonResult(authResultBuilder.build());
                    OafProtos.Oaf.Builder oafBuilder = OafProtos.Oaf.newBuilder();
                    oafBuilder.setKind(KindProtos.Kind.relation);
                    oafBuilder.setRel(relBuilder.build());
                    oafBuilder.setDataInfo(this.buildInference());
                    oafBuilder.setTimestamp(System.currentTimeMillis());
                    actions.add(this.actionFactory.createAtomicAction(this.actionSetId, agent, docId, relTypePersonResult.name(), authorIdStr, oafBuilder.build().toByteArray()));
                    actions.add(this.actionFactory.createAtomicAction(this.actionSetId, agent, authorIdStr, relTypePersonResult.name(), docId, DocumentWithInferencedDataActionBuilderModule.invertRelationAndBuild(oafBuilder)));
                }
                return actions;
            }
            return Collections.emptyList();
        }
    }
}

