/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.module;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.SimilarityRelProtos;
import eu.dnetlib.iis.export.actionmanager.module.AbstractBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderFactory;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.AlgorithmName;
import eu.dnetlib.iis.websiteusage.schemas.DocumentsWithWebsiteUsageSimilarities;
import java.util.Arrays;
import java.util.List;

public class DocumentsWithWebsiteUsageSimilaritiesActionBuilderModuleFactory
implements ActionBuilderFactory<DocumentsWithWebsiteUsageSimilarities> {
    @Override
    public AlgorithmName getAlgorithName() {
        return AlgorithmName.document_similarities_websiteusage;
    }

    @Override
    public ActionBuilderModule<DocumentsWithWebsiteUsageSimilarities> instantiate(String predefinedTrust, String actionSetId) {
        return new DocumentsWithWebsiteUsageSimilaritiesActionBuilder(predefinedTrust, actionSetId);
    }

    class DocumentsWithWebsiteUsageSimilaritiesActionBuilder
    extends AbstractBuilderModule
    implements ActionBuilderModule<DocumentsWithWebsiteUsageSimilarities> {
        private final float defaultSimilarityLevel = 0.0f;
        private final RelTypeProtos.RelType relTypeSimilarity;

        public DocumentsWithWebsiteUsageSimilaritiesActionBuilder(String predefinedTrust, String actionSetId) {
            super(predefinedTrust, actionSetId);
            this.defaultSimilarityLevel = 0.0f;
            this.relTypeSimilarity = RelTypeProtos.RelType.similarityRel;
        }

        @Override
        public List<AtomicAction> build(DocumentsWithWebsiteUsageSimilarities object, Agent agent) {
            String currentSimDocId = object.getOtherDocumentId().toString();
            String docId = object.getDocumentId().toString();
            return Arrays.asList(this.actionFactory.createAtomicAction(this.actionSetId, agent, docId, this.relTypeSimilarity.name(), currentSimDocId, this.buildSimilarityRel(docId, currentSimDocId, object.getCovisitedSimilarity() != null ? object.getCovisitedSimilarity().floatValue() : 0.0f).toByteArray()), this.actionFactory.createAtomicAction(this.actionSetId, agent, currentSimDocId, this.relTypeSimilarity.name(), docId, this.buildSimilarityRel(currentSimDocId, docId, object.getCovisitedSimilarity() != null ? object.getCovisitedSimilarity().floatValue() : 0.0f).toByteArray()));
        }

        private OafProtos.Oaf buildSimilarityRel(String source, String target, float score) {
            OafProtos.OafRel.Builder relBuilder = OafProtos.OafRel.newBuilder();
            relBuilder.setSource(source);
            relBuilder.setTarget(target);
            relBuilder.setChild(false);
            relBuilder.setRelType(this.relTypeSimilarity);
            relBuilder.setSimilarityRel(SimilarityRelProtos.SimilarityRel.newBuilder().setType(SimilarityRelProtos.SimilarityRel.Type.WEBUSAGE).setSimilarity(score).build());
            OafProtos.Oaf.Builder oafBuilder = OafProtos.Oaf.newBuilder();
            oafBuilder.setKind(KindProtos.Kind.relation);
            oafBuilder.setRel(relBuilder.build());
            oafBuilder.setDataInfo(this.buildInference());
            oafBuilder.setTimestamp(System.currentTimeMillis());
            return oafBuilder.build();
        }
    }
}

