package eu.dnetlib.iis.export.actionmanager.module;

import java.util.List;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;

/**
 * Action builder module.
 * @author mhorst
 *
 * @param <T>
 */
public interface ActionBuilderModule<T> {

	/**
	 * Creates collection of actions.
	 * @param object
	 * @param agent action agent
	 * This instance should be used in read-only mode.
	 * @return collection of actions
	 */
	List<AtomicAction> build(T object, Agent agent);
	
}

