package eu.dnetlib.iis.export.actionmanager.module;

import java.util.Collections;
import java.util.List;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.DocumentStatisticsProto.DocumentStatistics;
import eu.dnetlib.data.proto.OafProtos.Oaf;
import eu.dnetlib.data.proto.OafProtos.OafEntity;
import eu.dnetlib.data.proto.ResultProtos.Result;
import eu.dnetlib.data.proto.TypeProtos.Type;
import eu.dnetlib.iis.export.actionmanager.convert.AvroToProtobufConverter;
import eu.dnetlib.iis.statistics.schemas.DocumentToDocumentStatistics;

/**
 * {@link DocumentToDocumentStatistics} based action builder module.
 * @author mhorst
 *
 */
public class DocumentToDocumentStatisticsActionBuilderModuleFactory 
	implements ActionBuilderFactory<DocumentToDocumentStatistics> {

	class DocumentToDocumentStatisticsActionBuilderModule extends
	AbstractBuilderModule implements ActionBuilderModule<DocumentToDocumentStatistics> {
	
		/**
		 * Default constructor.
		 * @param predefinedTrust
		 * @param actionSetId
		 */
		public DocumentToDocumentStatisticsActionBuilderModule(
				String predefinedTrust, String actionSetId) {
			super(predefinedTrust, actionSetId);
		}
	
		@Override
		public List<AtomicAction> build(DocumentToDocumentStatistics object,
				Agent agent) {
			Oaf oaf = buildOAFStatistics(object);
			if (oaf!=null) {
				return actionFactory.createUpdateActions(
						actionSetId,
						agent, object.getDocumentId().toString(), Type.result, 
						oaf.toByteArray());	
			} else {
				return Collections.emptyList();
			}
		}
	
		/**
		 * Builds OAF object containing document statistics.
		 * @param source
		 * @return OAF object containing document statistics
		 */
		protected Oaf buildOAFStatistics(DocumentToDocumentStatistics source) {
			if (source.getStatistics()!=null) {
				eu.dnetlib.data.proto.ResultProtos.Result.Builder resultBuilder = Result.newBuilder();
				DocumentStatistics docStatistics = AvroToProtobufConverter.convertAvroToProtoBuff(
						source.getStatistics());
				if (docStatistics!=null) {
					resultBuilder.setStatistics(docStatistics);
					eu.dnetlib.data.proto.OafProtos.OafEntity.Builder entityBuilder = OafEntity.newBuilder();
					if (source.getDocumentId()!=null) {
						entityBuilder.setId(source.getDocumentId().toString());	
					}
					entityBuilder.setType(Type.result);
					entityBuilder.setResult(resultBuilder.build());	
					return buildOaf(entityBuilder.build());
				}
			}
//			fallback
			return null;
		}

	}
	
	@Override
	public AlgorithmName getAlgorithName() {
		return AlgorithmName.document_statistics;
	}

	@Override
	public ActionBuilderModule<DocumentToDocumentStatistics> instantiate(
			String predefinedTrust, String actionSetId) {
		return new DocumentToDocumentStatisticsActionBuilderModule(
				predefinedTrust, actionSetId);
	}
}
