/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.convert;

import eu.dnetlib.data.proto.AuthorStatisticsProto;
import eu.dnetlib.data.proto.BasicCitationStatisticsProtos;
import eu.dnetlib.data.proto.CommonCoreStatisticsProto;
import eu.dnetlib.data.proto.CoreStatisticsProto;
import eu.dnetlib.data.proto.DocumentClassesProto;
import eu.dnetlib.data.proto.DocumentClustersProto;
import eu.dnetlib.data.proto.DocumentStatisticsProto;
import eu.dnetlib.data.proto.ExtendedStatisticsProto;
import eu.dnetlib.data.proto.StatisticsKeyValueProtos;
import eu.dnetlib.iis.documentsclassification.schemas.DocumentClass;
import eu.dnetlib.iis.documentsclassification.schemas.DocumentClasses;
import eu.dnetlib.iis.documentsclustering.schemas.DocumentClusters;
import eu.dnetlib.iis.statistics.schemas.AuthorStatistics;
import eu.dnetlib.iis.statistics.schemas.BasicCitationStatistics;
import eu.dnetlib.iis.statistics.schemas.CoAuthor;
import eu.dnetlib.iis.statistics.schemas.CommonBasicCitationStatistics;
import eu.dnetlib.iis.statistics.schemas.CommonCoreStatistics;
import eu.dnetlib.iis.statistics.schemas.CoreStatistics;
import eu.dnetlib.iis.statistics.schemas.ExtendedStatistics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AvroToProtobufConverter {
    private AvroToProtobufConverter() {
    }

    private static BasicCitationStatisticsProtos.BasicCitationStatistics convertAvroToProtoBuff(BasicCitationStatistics source) {
        if (source != null) {
            BasicCitationStatisticsProtos.BasicCitationStatistics.Builder builder = BasicCitationStatisticsProtos.BasicCitationStatistics.newBuilder();
            builder.setNumberOfCitations(source.getNumberOfCitations().intValue());
            if (source.getNumberOfCitationsPerYear() != null) {
                for (Map.Entry mapEntry : source.getNumberOfCitationsPerYear().entrySet()) {
                    builder.addNumberOfCitationsPerYear(AvroToProtobufConverter.convertToProtoBuff((CharSequence)mapEntry.getKey(), (Integer)mapEntry.getValue()));
                }
            }
            return builder.build();
        }
        return null;
    }

    private static StatisticsKeyValueProtos.StatisticsKeyValue convertToProtoBuff(CharSequence key, Integer value) {
        if (key != null) {
            StatisticsKeyValueProtos.StatisticsKeyValue.Builder builder = StatisticsKeyValueProtos.StatisticsKeyValue.newBuilder();
            builder.setKey(key.toString());
            builder.setValue(value.intValue());
            return builder.build();
        }
        return null;
    }

    private static ExtendedStatisticsProto.ExtendedStatistics convertToProtoBuff(ExtendedStatistics source) {
        if (source != null) {
            ExtendedStatisticsProto.ExtendedStatistics.Builder builder = ExtendedStatisticsProto.ExtendedStatistics.newBuilder();
            if (source.getBasic() != null) {
                builder.setBasic(AvroToProtobufConverter.convertAvroToProtoBuff(source.getBasic()));
            }
            builder.setAverageNumberOfCitationsPerPaper(source.getAverageNumberOfCitationsPerPaper().floatValue());
            if (source.getNumberOfPapersCitedAtLeastXTimes() != null) {
                for (Map.Entry mapEntry : source.getNumberOfPapersCitedAtLeastXTimes().entrySet()) {
                    builder.addNumberOfPapersCitedAtLeastXTimes(AvroToProtobufConverter.convertToProtoBuff((CharSequence)mapEntry.getKey(), (Integer)mapEntry.getValue()));
                }
            }
            return builder.build();
        }
        return null;
    }

    private static CoreStatisticsProto.CoreStatistics convertAvroToProtoBuff(CoreStatistics source) {
        if (source != null) {
            CoreStatisticsProto.CoreStatistics.Builder builder = CoreStatisticsProto.CoreStatistics.newBuilder();
            builder.setNumberOfPapers(source.getNumberOfPapers().intValue());
            if (source.getCitationsFromAllPapers() != null) {
                builder.setCitationsFromAllPapers(AvroToProtobufConverter.convertToProtoBuff(source.getCitationsFromAllPapers()));
            }
            if (source.getCitationsFromPublishedPapers() != null) {
                builder.setCitationsFromPublishedPapers(AvroToProtobufConverter.convertToProtoBuff(source.getCitationsFromPublishedPapers()));
            }
            return builder.build();
        }
        return null;
    }

    private static AuthorStatisticsProto.CoAuthor convertAvroToProtoBuff(CoAuthor source) {
        if (source != null) {
            AuthorStatisticsProto.CoAuthor.Builder builder = AuthorStatisticsProto.CoAuthor.newBuilder();
            builder.setId(source.getId().toString());
            builder.setCoauthoredPapersCount(source.getCoauthoredPapersCount().intValue());
            return builder.build();
        }
        return null;
    }

    public static CommonCoreStatisticsProto.CommonCoreStatistics convertAvroToProtoBuff(CommonCoreStatistics source) {
        if (source != null) {
            CommonCoreStatisticsProto.CommonCoreStatistics.Builder builder = CommonCoreStatisticsProto.CommonCoreStatistics.newBuilder();
            if (source.getAllPapers() != null) {
                builder.setAllPapers(AvroToProtobufConverter.convertAvroToProtoBuff(source.getAllPapers()));
            }
            if (source.getPublishedPapers() != null) {
                builder.setPublishedPapers(AvroToProtobufConverter.convertAvroToProtoBuff(source.getPublishedPapers()));
            }
            return builder.build();
        }
        return null;
    }

    public static AuthorStatisticsProto.AuthorStatistics convertAvroToProtoBuff(AuthorStatistics source) {
        if (source != null) {
            AuthorStatisticsProto.AuthorStatistics.Builder builder = AuthorStatisticsProto.AuthorStatistics.newBuilder();
            if (source.getCore() != null) {
                builder.setCore(AvroToProtobufConverter.convertAvroToProtoBuff(source.getCore()));
            }
            if (source.getCoAuthors() != null && source.getCoAuthors().size() > 0) {
                for (CoAuthor currentCoauthor : source.getCoAuthors()) {
                    builder.addCoAuthors(AvroToProtobufConverter.convertAvroToProtoBuff(currentCoauthor));
                }
            }
            return builder.build();
        }
        return null;
    }

    public static DocumentStatisticsProto.DocumentStatistics convertAvroToProtoBuff(CommonBasicCitationStatistics source) {
        if (source != null) {
            DocumentStatisticsProto.DocumentStatistics.Builder builder = DocumentStatisticsProto.DocumentStatistics.newBuilder();
            if (source.getCitationsFromAllPapers() != null) {
                builder.setCitationsFromAllPapers(AvroToProtobufConverter.convertAvroToProtoBuff(source.getCitationsFromAllPapers()));
            }
            if (source.getCitationsFromPublishedPapers() != null) {
                builder.setCitationsFromPublishedPapers(AvroToProtobufConverter.convertAvroToProtoBuff(source.getCitationsFromPublishedPapers()));
            }
            return builder.build();
        }
        return null;
    }

    public static DocumentClustersProto.DocumentClusters convertAvroToProtoBuff(DocumentClusters source) {
        if (source != null) {
            DocumentClustersProto.DocumentClusters.Builder builder = DocumentClustersProto.DocumentClusters.newBuilder();
            if (source.getClusteringMethod1ClusterId() != null) {
                builder.setClusteringMethod1ClusterId(source.getClusteringMethod1ClusterId().intValue());
            }
            if (source.getClusteringMethod2ClusterId() != null) {
                builder.setClusteringMethod2ClusterId(source.getClusteringMethod2ClusterId().intValue());
            }
            return builder.build();
        }
        return null;
    }

    public static DocumentClassesProto.DocumentClasses convertAvroToProtoBuff(DocumentClasses source) {
        if (source != null) {
            DocumentClassesProto.DocumentClasses.Builder builder = DocumentClassesProto.DocumentClasses.newBuilder();
            if (source.getArXivClasses() != null && !source.getArXivClasses().isEmpty()) {
                builder.addAllArXivClasses(AvroToProtobufConverter.convertAvroToProtoBuff(source.getArXivClasses()));
            }
            if (source.getDDCClasses() != null && !source.getDDCClasses().isEmpty()) {
                builder.addAllDdcClasses(AvroToProtobufConverter.convertAvroToProtoBuff(source.getDDCClasses()));
            }
            if (source.getWoSClasses() != null && !source.getWoSClasses().isEmpty()) {
                builder.addAllWosClasses(AvroToProtobufConverter.convertAvroToProtoBuff(source.getWoSClasses()));
            }
            if (source.getMeshEuroPMCClasses() != null && !source.getMeshEuroPMCClasses().isEmpty()) {
                builder.addAllMeshEuroPMCClasses(AvroToProtobufConverter.convertAvroToProtoBuff(source.getMeshEuroPMCClasses()));
            }
            return builder.build();
        }
        return null;
    }

    public static List<DocumentClassesProto.DocumentClass> convertAvroToProtoBuff(List<DocumentClass> source) {
        ArrayList<DocumentClassesProto.DocumentClass> result = new ArrayList<DocumentClassesProto.DocumentClass>();
        for (DocumentClass current : source) {
            if (current == null) continue;
            result.add(AvroToProtobufConverter.convertAvroToProtoBuff(current));
        }
        return result;
    }

    public static DocumentClassesProto.DocumentClass convertAvroToProtoBuff(DocumentClass source) {
        if (source != null) {
            DocumentClassesProto.DocumentClass.Builder builder = DocumentClassesProto.DocumentClass.newBuilder();
            if (source.getClassLabels() != null) {
                for (CharSequence current : source.getClassLabels()) {
                    builder.addClassLabels(current.toString());
                }
            }
            if (source.getConfidenceLevel() != null) {
                builder.setConfidenceLevel(source.getConfidenceLevel().floatValue());
            }
            return builder.build();
        }
        return null;
    }
}

