/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.generator;

import eu.dnetlib.iis.core.java.HadoopContext;
import eu.dnetlib.iis.core.java.PortBindings;
import eu.dnetlib.iis.core.java.Ports;
import eu.dnetlib.iis.core.java.Process;
import eu.dnetlib.iis.core.java.io.DataStore;
import eu.dnetlib.iis.core.java.io.FileSystemPath;
import eu.dnetlib.iis.core.java.porttype.AnyPortType;
import eu.dnetlib.iis.core.java.porttype.AvroPortType;
import eu.dnetlib.iis.core.java.porttype.PortType;
import eu.dnetlib.iis.documentssimilarity.schemas.DocumentSimilarity;
import eu.dnetlib.iis.export.actionmanager.generator.ExportMode;
import eu.dnetlib.iis.export.schemas.DataSetReferenceWithInferencedData;
import eu.dnetlib.iis.export.schemas.DocumentWithInferencedData;
import eu.dnetlib.iis.export.schemas.PersonWithInferencedData;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.log4j.Logger;

public class JsonBasedInferencedDataGenerator
implements Process {
    private final Logger log = Logger.getLogger(this.getClass());
    private static final Ports ports;
    private static final Map<ExportMode, JsonInput> modeToPathMap;

    public Map<String, PortType> getInputPorts() {
        return JsonBasedInferencedDataGenerator.getStaticPorts().getInput();
    }

    public Map<String, PortType> getOutputPorts() {
        return JsonBasedInferencedDataGenerator.getStaticPorts().getOutput();
    }

    public static Ports getStaticPorts() {
        return ports;
    }

    public void run(PortBindings portBindings, HadoopContext context, Map<String, String> parameters) throws Exception {
        for (ExportMode currentMode : modeToPathMap.keySet()) {
            this.handleMode(currentMode, portBindings, context, parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMode(ExportMode mode, PortBindings portBindings, HadoopContext context, Map<String, String> parameters) throws IOException {
        Path inputPath = (Path)portBindings.getInput().get(modeToPathMap.get((Object)mode).name());
        FileSystem fs = FileSystem.get((Configuration)context.getConfiguration());
        if (fs.exists(inputPath)) {
            Schema schema = ((AvroPortType)ports.getOutput().get(mode.name())).getSchema();
            DataFileWriter writer = null;
            try {
                if (fs.isDirectory(inputPath)) {
                    RemoteIterator statusIt = fs.listFiles(inputPath, true);
                    while (statusIt.hasNext()) {
                        LocatedFileStatus fileStatus;
                        if (writer == null) {
                            writer = DataStore.create((FileSystemPath)new FileSystemPath(fs, (Path)portBindings.getOutput().get(mode.name())), (Schema)schema);
                        }
                        if (!(fileStatus = (LocatedFileStatus)statusIt.next()).isDirectory()) {
                            FSDataInputStream inputStream = fs.open(fileStatus.getPath());
                            try {
                                writer.append(this.convertJsonToAvro((InputStream)inputStream, schema));
                                continue;
                            }
                            finally {
                                inputStream.close();
                                continue;
                            }
                        }
                        this.log.debug((Object)("skipping directory:" + fileStatus.getPath().toString()));
                    }
                }
                FSDataInputStream inputStream = fs.open(inputPath);
                try {
                    writer = DataStore.create((FileSystemPath)new FileSystemPath(fs, (Path)portBindings.getOutput().get(mode.name())), (Schema)schema);
                    writer.append(this.convertJsonToAvro((InputStream)inputStream, schema));
                }
                finally {
                    inputStream.close();
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        } else {
            this.log.warn((Object)("unable to generate data for mode " + (Object)((Object)mode) + ", no directory found for path: " + inputPath));
        }
    }

    protected <T extends SpecificRecord> T convertJsonToAvro(InputStream jsonInputStream, Schema schema) throws IOException {
        if (jsonInputStream == null) {
            return null;
        }
        SpecificDatumReader datumReader = new SpecificDatumReader(schema);
        JsonDecoder decoder = DecoderFactory.get().jsonDecoder(schema, jsonInputStream);
        return (T)((SpecificRecord)datumReader.read(null, (Decoder)decoder));
    }

    static {
        HashMap<String, AnyPortType> input = new HashMap<String, AnyPortType>();
        input.put(JsonInput.json_document_similarity.name(), new AnyPortType());
        input.put(JsonInput.json_document_with_inferenced_data.name(), new AnyPortType());
        input.put(JsonInput.json_dataset_with_inferenced_data.name(), new AnyPortType());
        input.put(JsonInput.json_person_with_inferenced_data.name(), new AnyPortType());
        HashMap<String, AvroPortType> output = new HashMap<String, AvroPortType>();
        output.put(ExportMode.document_similarity.name(), new AvroPortType(DocumentSimilarity.SCHEMA$));
        output.put(ExportMode.document_with_inferenced_data.name(), new AvroPortType(DocumentWithInferencedData.SCHEMA$));
        output.put(ExportMode.dataset_with_inferenced_data.name(), new AvroPortType(DataSetReferenceWithInferencedData.SCHEMA$));
        output.put(ExportMode.person_with_inferenced_data.name(), new AvroPortType(PersonWithInferencedData.SCHEMA$));
        ports = new Ports(input, output);
        modeToPathMap = new HashMap<ExportMode, JsonInput>();
        modeToPathMap.put(ExportMode.document_similarity, JsonInput.json_document_similarity);
        modeToPathMap.put(ExportMode.document_with_inferenced_data, JsonInput.json_document_with_inferenced_data);
        modeToPathMap.put(ExportMode.dataset_with_inferenced_data, JsonInput.json_dataset_with_inferenced_data);
        modeToPathMap.put(ExportMode.person_with_inferenced_data, JsonInput.json_person_with_inferenced_data);
    }

    public static enum JsonInput {
        json_document_similarity,
        json_document_with_inferenced_data,
        json_dataset_with_inferenced_data,
        json_person_with_inferenced_data;

    }
}

