/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.module;

import eu.dnetlib.actionmanager.actions.ActionFactory;
import eu.dnetlib.data.proto.DataInfoProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.QualifierProtos;
import eu.dnetlib.data.proto.RelMetadataProtos;
import eu.dnetlib.data.proto.RelTypeProtos;

public abstract class AbstractBuilderModule {
    private final String predefinedTrust;
    protected final String actionSetId;
    protected final ActionFactory actionFactory = new ActionFactory();

    public AbstractBuilderModule(String predefinedTrust, String actionSetId) {
        this.predefinedTrust = predefinedTrust;
        this.actionSetId = actionSetId;
    }

    protected OafProtos.Oaf buildOaf(OafProtos.OafEntity oafEntity) {
        OafProtos.Oaf.Builder oafBuilder = OafProtos.Oaf.newBuilder();
        oafBuilder.setKind(KindProtos.Kind.entity);
        oafBuilder.setEntity(oafEntity);
        oafBuilder.setDataInfo(this.buildInference());
        oafBuilder.setTimestamp(System.currentTimeMillis());
        return oafBuilder.build();
    }

    protected DataInfoProtos.DataInfo buildInference() {
        DataInfoProtos.DataInfo.Builder builder = DataInfoProtos.DataInfo.newBuilder();
        builder.setInferred(true);
        builder.setTrust(this.predefinedTrust);
        QualifierProtos.Qualifier.Builder provenanceBuilder = QualifierProtos.Qualifier.newBuilder();
        provenanceBuilder.setClassid("iis");
        provenanceBuilder.setClassname("iis");
        provenanceBuilder.setSchemeid("dnet:provenanceActions");
        provenanceBuilder.setSchemename("dnet:provenanceActions");
        builder.setProvenanceaction(provenanceBuilder.build());
        return builder.build();
    }

    protected RelMetadataProtos.RelMetadata buildRelMetadata(String schemaId, String classId) {
        RelMetadataProtos.RelMetadata.Builder relBuilder = RelMetadataProtos.RelMetadata.newBuilder();
        QualifierProtos.Qualifier.Builder qBuilder = QualifierProtos.Qualifier.newBuilder();
        qBuilder.setSchemeid(schemaId);
        qBuilder.setSchemename(schemaId);
        qBuilder.setClassid(classId);
        qBuilder.setClassname(classId);
        relBuilder.setSemantics(qBuilder.build());
        return relBuilder.build();
    }

    protected OafProtos.Oaf buildSameObjectRelation(String sourceId, String targetId, RelTypeProtos.RelType relType) {
        OafProtos.OafRel.Builder relBuilder = OafProtos.OafRel.newBuilder();
        relBuilder.setSource(sourceId);
        relBuilder.setTarget(targetId);
        relBuilder.setChild(false);
        relBuilder.setRelType(relType);
        OafProtos.Oaf.Builder oafBuilder = OafProtos.Oaf.newBuilder();
        oafBuilder.setKind(KindProtos.Kind.relation);
        oafBuilder.setRel(relBuilder.build());
        oafBuilder.setDataInfo(this.buildInference());
        oafBuilder.setTimestamp(System.currentTimeMillis());
        return oafBuilder.build();
    }

    public static byte[] invertRelationAndBuild(OafProtos.Oaf.Builder existingBuilder) {
        if (existingBuilder.getRel() != null) {
            if (existingBuilder.getRel().getSource() != null && existingBuilder.getRel().getTarget() != null) {
                OafProtos.Oaf.Builder builder = existingBuilder.clone();
                OafProtos.OafRel.Builder relBuilder = builder.getRelBuilder();
                String source = relBuilder.getSource();
                String target = relBuilder.getTarget();
                relBuilder.setSource(target);
                relBuilder.setTarget(source);
                builder.setRel(relBuilder.build());
                builder.setTimestamp(System.currentTimeMillis());
                return builder.build().toByteArray();
            }
            throw new RuntimeException("invalid state: either source or target relation was missing!");
        }
        throw new RuntimeException("invalid state: no relation object found!");
    }
}

