/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.module;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.CitationProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.iis.citationmatching.schemas.Citation;
import eu.dnetlib.iis.export.actionmanager.module.AbstractBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderFactory;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.AlgorithmName;
import java.util.Arrays;
import java.util.List;

public class CitationActionBuilderModuleFactory
implements ActionBuilderFactory<Citation> {
    @Override
    public AlgorithmName getAlgorithName() {
        return AlgorithmName.document_referencedDocuments;
    }

    @Override
    public ActionBuilderModule<Citation> instantiate(String predefinedTrust, String actionSetId) {
        return new CitationActionBuilderModule(predefinedTrust, actionSetId);
    }

    class CitationActionBuilderModule
    extends AbstractBuilderModule
    implements ActionBuilderModule<Citation> {
        private final RelTypeProtos.RelType relTypeCitation;

        public CitationActionBuilderModule(String predefinedTrust, String actionSetId) {
            super(predefinedTrust, actionSetId);
            this.relTypeCitation = RelTypeProtos.RelType.citation;
        }

        @Override
        public List<AtomicAction> build(Citation object, Agent agent) {
            String docId = object.getSourceDocumentId().toString();
            String currentRefId = object.getDestinationDocumentId().toString();
            OafProtos.Oaf.Builder oafBuilder = OafProtos.Oaf.newBuilder();
            oafBuilder.setKind(KindProtos.Kind.relation);
            OafProtos.OafRel.Builder relBuilder = OafProtos.OafRel.newBuilder();
            relBuilder.setChild(false);
            relBuilder.setRelType(this.relTypeCitation);
            relBuilder.setSource(docId);
            relBuilder.setTarget(currentRefId);
            CitationProtos.Citation.Builder resResBuilder = CitationProtos.Citation.newBuilder();
            resResBuilder.setReferenceText(object.getRawText().toString());
            resResBuilder.setRelMetadata(this.buildRelMetadata("dnet:dataset_publication_rels", "cites"));
            relBuilder.setCitation(resResBuilder);
            oafBuilder.setRel(relBuilder);
            oafBuilder.setDataInfo(this.buildInference());
            oafBuilder.setTimestamp(System.currentTimeMillis());
            return Arrays.asList(this.actionFactory.createAtomicAction(this.actionSetId, agent, docId, this.relTypeCitation.name(), currentRefId, oafBuilder.build().toByteArray()), this.actionFactory.createAtomicAction(this.actionSetId, agent, currentRefId, this.relTypeCitation.name(), docId, this.invertCitationRelationAndBuild(oafBuilder)));
        }

        private byte[] invertCitationRelationAndBuild(OafProtos.Oaf.Builder existingBuilder) {
            if (existingBuilder.getRel() != null) {
                if (existingBuilder.getRel().getSource() != null && existingBuilder.getRel().getTarget() != null) {
                    OafProtos.Oaf.Builder builder = existingBuilder.clone();
                    OafProtos.OafRel.Builder relBuilder = builder.getRelBuilder();
                    String source = relBuilder.getSource();
                    String target = relBuilder.getTarget();
                    relBuilder.setSource(target);
                    relBuilder.setTarget(source);
                    if (relBuilder.getResultResultBuilder() == null || relBuilder.getResultResultBuilder().getRelMetadataBuilder() == null || relBuilder.getResultResultBuilder().getRelMetadataBuilder().getSemanticsBuilder() == null) {
                        throw new RuntimeException("unable to set proper citation semantics, no semantics set for original citation relation!");
                    }
                    relBuilder.getResultResultBuilder().getRelMetadataBuilder().getSemanticsBuilder().setClassid("citedBy");
                    relBuilder.getResultResultBuilder().getRelMetadataBuilder().getSemanticsBuilder().setClassname("citedBy");
                    builder.setRel(relBuilder.build());
                    builder.setTimestamp(System.currentTimeMillis());
                    return builder.build().toByteArray();
                }
                throw new RuntimeException("invalid state: either source or target relation was missing!");
            }
            throw new RuntimeException("invalid state: no relation object found!");
        }
    }
}

