/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.module;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.SimilarityRelProtos;
import eu.dnetlib.iis.export.actionmanager.module.AbstractBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderFactory;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.AlgorithmName;
import eu.dnetlib.iis.websiteusage.schemas.PersonsWithWebsiteUsageSimilarities;
import java.util.Arrays;
import java.util.List;

public class PersonsWithWebsiteUsageSimilaritiesActionBuilderModuleFactory
implements ActionBuilderFactory<PersonsWithWebsiteUsageSimilarities> {
    @Override
    public AlgorithmName getAlgorithName() {
        return AlgorithmName.person_similarities_websiteusage;
    }

    @Override
    public ActionBuilderModule<PersonsWithWebsiteUsageSimilarities> instantiate(String predefinedTrust, String actionSetId) {
        return new PersonsWithWebsiteUsageSimilaritiesActionBuilderModule(predefinedTrust, actionSetId);
    }

    class PersonsWithWebsiteUsageSimilaritiesActionBuilderModule
    extends AbstractBuilderModule
    implements ActionBuilderModule<PersonsWithWebsiteUsageSimilarities> {
        private final float defaultSimilarityLevel = 0.0f;

        public PersonsWithWebsiteUsageSimilaritiesActionBuilderModule(String predefinedTrust, String actionSetId) {
            super(predefinedTrust, actionSetId);
            this.defaultSimilarityLevel = 0.0f;
        }

        @Override
        public List<AtomicAction> build(PersonsWithWebsiteUsageSimilarities object, Agent agent) {
            return Arrays.asList(this.createSimilarityRelAction(this.actionSetId, agent, object.getPersonId().toString(), object.getOtherPersonId().toString(), object.getSimilarities() != null ? object.getSimilarities().getCovisitedSimilarity().floatValue() : 0.0f), this.createSimilarityRelAction(this.actionSetId, agent, object.getOtherPersonId().toString(), object.getPersonId().toString(), object.getSimilarities() != null ? object.getSimilarities().getCovisitedSimilarity().floatValue() : 0.0f));
        }

        protected AtomicAction createSimilarityRelAction(String actionSet, Agent agent, String personId, String otherPersonId, float similarityLevel) {
            return this.actionFactory.createAtomicAction(actionSet, agent, personId, RelTypeProtos.RelType.similarityRel.name(), otherPersonId, this.buildOAFRel(personId, otherPersonId, similarityLevel).toByteArray());
        }

        protected OafProtos.Oaf buildOAFRel(String source, String target, float score) {
            OafProtos.OafRel.Builder relBuilder = OafProtos.OafRel.newBuilder();
            relBuilder.setSource(source);
            relBuilder.setTarget(target);
            relBuilder.setChild(false);
            relBuilder.setRelType(RelTypeProtos.RelType.similarityRel);
            relBuilder.setSimilarityRel(SimilarityRelProtos.SimilarityRel.newBuilder().setType(SimilarityRelProtos.SimilarityRel.Type.WEBUSAGE).setSimilarity(score).build());
            OafProtos.Oaf.Builder oafBuilder = OafProtos.Oaf.newBuilder();
            oafBuilder.setKind(KindProtos.Kind.relation);
            oafBuilder.setRel(relBuilder.build());
            oafBuilder.setDataInfo(this.buildInference());
            oafBuilder.setTimestamp(System.currentTimeMillis());
            return oafBuilder.build();
        }
    }
}

