/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.export.actionmanager.module;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.CommonCoreStatisticsProto;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ProjectProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.iis.export.actionmanager.convert.AvroToProtobufConverter;
import eu.dnetlib.iis.export.actionmanager.module.AbstractBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderFactory;
import eu.dnetlib.iis.export.actionmanager.module.ActionBuilderModule;
import eu.dnetlib.iis.export.actionmanager.module.AlgorithmName;
import eu.dnetlib.iis.statistics.schemas.ProjectToProjectStatistics;
import java.util.List;

public class ProjectToProjectStatisticsActionBuilderModuleFactory
implements ActionBuilderFactory<ProjectToProjectStatistics> {
    @Override
    public AlgorithmName getAlgorithName() {
        return AlgorithmName.project_statistics;
    }

    @Override
    public ActionBuilderModule<ProjectToProjectStatistics> instantiate(String predefinedTrust, String actionSetId) {
        return new ProjectToProjectStatisticsActionBuilderModule(predefinedTrust, actionSetId);
    }

    class ProjectToProjectStatisticsActionBuilderModule
    extends AbstractBuilderModule
    implements ActionBuilderModule<ProjectToProjectStatistics> {
        public ProjectToProjectStatisticsActionBuilderModule(String predefinedTrust, String actionSetId) {
            super(predefinedTrust, actionSetId);
        }

        @Override
        public List<AtomicAction> build(ProjectToProjectStatistics object, Agent agent) {
            OafProtos.Oaf oafObject = this.buildOAF(object);
            if (oafObject != null) {
                return this.actionFactory.createUpdateActions(this.actionSetId, agent, object.getProjectId().toString(), TypeProtos.Type.project, oafObject.toByteArray());
            }
            return null;
        }

        protected OafProtos.Oaf buildOAF(ProjectToProjectStatistics source) {
            ProjectProtos.Project project = this.buildProjectStatistics(source);
            if (project != null) {
                OafProtos.OafEntity.Builder entityBuilder = OafProtos.OafEntity.newBuilder();
                if (source.getProjectId() != null) {
                    entityBuilder.setId(source.getProjectId().toString());
                }
                entityBuilder.setProject(project);
                entityBuilder.setType(TypeProtos.Type.project);
                return this.buildOaf(entityBuilder.build());
            }
            return null;
        }

        protected ProjectProtos.Project buildProjectStatistics(ProjectToProjectStatistics source) {
            CommonCoreStatisticsProto.CommonCoreStatistics convertedStatistics;
            if (source.getStatistics() != null && (convertedStatistics = AvroToProtobufConverter.convertAvroToProtoBuff(source.getStatistics())) != null) {
                ProjectProtos.Project.Builder projectBuilder = ProjectProtos.Project.newBuilder();
                projectBuilder.setStatistics(convertedStatistics);
                return projectBuilder.build();
            }
            return null;
        }
    }
}

