package eu.dnetlib.iis.export.actionmanager.convert;

import java.util.ArrayList;
import java.util.List;
import java.util.Map.Entry;

import eu.dnetlib.data.proto.AuthorStatisticsProto.AuthorStatistics;
import eu.dnetlib.data.proto.AuthorStatisticsProto.CoAuthor;
import eu.dnetlib.data.proto.BasicCitationStatisticsProtos.BasicCitationStatistics;
import eu.dnetlib.data.proto.CommonCoreStatisticsProto.CommonCoreStatistics;
import eu.dnetlib.data.proto.CoreStatisticsProto.CoreStatistics;
import eu.dnetlib.data.proto.DocumentClassesProto.DocumentClass;
import eu.dnetlib.data.proto.DocumentClassesProto.DocumentClasses;
import eu.dnetlib.data.proto.DocumentClustersProto.DocumentClusters;
import eu.dnetlib.data.proto.DocumentStatisticsProto.DocumentStatistics;
import eu.dnetlib.data.proto.ExtendedStatisticsProto.ExtendedStatistics;
import eu.dnetlib.data.proto.StatisticsKeyValueProtos.StatisticsKeyValue;



/**
 * Avro to protocol buffer converter.
 * @author mhorst
 *
 */
public class AvroToProtobufConverter {

	private AvroToProtobufConverter() {}

	private static BasicCitationStatistics convertAvroToProtoBuff(eu.dnetlib.iis.statistics.schemas.BasicCitationStatistics source) {
		if (source!=null) {
			BasicCitationStatistics.Builder builder = BasicCitationStatistics.newBuilder();
			builder.setNumberOfCitations(source.getNumberOfCitations());
			if (source.getNumberOfCitationsPerYear()!=null) {
				for (Entry<CharSequence, Integer> mapEntry : source.getNumberOfCitationsPerYear().entrySet()) {
					builder.addNumberOfCitationsPerYear(convertToProtoBuff(
							mapEntry.getKey(), mapEntry.getValue()));
				}
			}
			return builder.build();
		} else {
			return null;
		}
	}
	
	private static StatisticsKeyValue convertToProtoBuff(CharSequence key, Integer value) {
		if (key!=null) {
			StatisticsKeyValue.Builder builder = StatisticsKeyValue.newBuilder();
			builder.setKey(key.toString());
			builder.setValue(value);
			return builder.build();
		} else {
			return null;
		}
	}
	
	private static ExtendedStatistics convertToProtoBuff(eu.dnetlib.iis.statistics.schemas.ExtendedStatistics source) {
		if (source!=null) {
			ExtendedStatistics.Builder builder = ExtendedStatistics.newBuilder();
			if (source.getBasic()!=null) {
				builder.setBasic(convertAvroToProtoBuff(source.getBasic()));
			}
			builder.setAverageNumberOfCitationsPerPaper(source.getAverageNumberOfCitationsPerPaper());
			if (source.getNumberOfPapersCitedAtLeastXTimes()!=null) {
				for (Entry<CharSequence, Integer> mapEntry : source.getNumberOfPapersCitedAtLeastXTimes().entrySet()) {
					builder.addNumberOfPapersCitedAtLeastXTimes(convertToProtoBuff(
							mapEntry.getKey(), mapEntry.getValue()));
				}
			}
			return builder.build();
		} else {
			return null;
		}
	}
	
	private static CoreStatistics convertAvroToProtoBuff(eu.dnetlib.iis.statistics.schemas.CoreStatistics source) {
		if (source!=null) {
			CoreStatistics.Builder builder = CoreStatistics.newBuilder();
			builder.setNumberOfPapers(source.getNumberOfPapers());
			if (source.getCitationsFromAllPapers()!=null) {
				builder.setCitationsFromAllPapers(convertToProtoBuff(
						source.getCitationsFromAllPapers()));
			}
			if (source.getCitationsFromPublishedPapers()!=null) {
				builder.setCitationsFromPublishedPapers(convertToProtoBuff(
						source.getCitationsFromPublishedPapers()));
			}
			return builder.build();
		} else {
			return null;
		}
	}

	private static CoAuthor convertAvroToProtoBuff(eu.dnetlib.iis.statistics.schemas.CoAuthor source) {
		if (source!=null) {
			CoAuthor.Builder builder = CoAuthor.newBuilder();
			builder.setId(source.getId().toString());	
			builder.setCoauthoredPapersCount(source.getCoauthoredPapersCount());	
			return builder.build();
		} else {
			return null;
		}
	}

	public static CommonCoreStatistics convertAvroToProtoBuff(eu.dnetlib.iis.statistics.schemas.CommonCoreStatistics source) {
		if (source!=null) {
			CommonCoreStatistics.Builder builder = CommonCoreStatistics.newBuilder();
			if (source.getAllPapers()!=null) {
				builder.setAllPapers(convertAvroToProtoBuff(source.getAllPapers()));
			}
			if (source.getPublishedPapers()!=null) {
				builder.setPublishedPapers(convertAvroToProtoBuff(source.getPublishedPapers()));
			}
			return builder.build();
		} else {
			return null;
		}
	}
	
	public static AuthorStatistics convertAvroToProtoBuff(eu.dnetlib.iis.statistics.schemas.AuthorStatistics source) {
		if (source!=null) {
			AuthorStatistics.Builder builder = AuthorStatistics.newBuilder();
			if (source.getCore()!=null) {
				builder.setCore(convertAvroToProtoBuff(source.getCore()));
			}
			if (source.getCoAuthors()!=null && source.getCoAuthors().size()>0) {
				for (eu.dnetlib.iis.statistics.schemas.CoAuthor currentCoauthor : source.getCoAuthors()) {
					builder.addCoAuthors(convertAvroToProtoBuff(currentCoauthor));
				}
			}
			return builder.build();
		} else {
			return null;
		}
	}
	
	public static DocumentStatistics convertAvroToProtoBuff(eu.dnetlib.iis.statistics.schemas.CommonBasicCitationStatistics source) {
		if (source!=null) {
			DocumentStatistics.Builder builder = DocumentStatistics.newBuilder();
			if (source.getCitationsFromAllPapers()!=null) {
				builder.setCitationsFromAllPapers(convertAvroToProtoBuff(
						source.getCitationsFromAllPapers()));
			}
			if (source.getCitationsFromPublishedPapers()!=null) {
				builder.setCitationsFromPublishedPapers(convertAvroToProtoBuff(
						source.getCitationsFromPublishedPapers()));
			}
			return builder.build();
		} else {
			return null;
		}
	}
	
	public static DocumentClusters convertAvroToProtoBuff(eu.dnetlib.iis.documentsclustering.schemas.DocumentClusters source) {
		if (source!=null) {
			DocumentClusters.Builder builder = DocumentClusters.newBuilder();
			if (source.getClusteringMethod1ClusterId()!=null) {
				builder.setClusteringMethod1ClusterId(source.getClusteringMethod1ClusterId());
			}
			if (source.getClusteringMethod2ClusterId()!=null) {
				builder.setClusteringMethod2ClusterId(source.getClusteringMethod2ClusterId());
			}
			return builder.build();
		} else {
			return null;
		}
	}
	
	public static DocumentClasses convertAvroToProtoBuff(eu.dnetlib.iis.documentsclassification.schemas.DocumentClasses source) {
		if (source!=null) {
			DocumentClasses.Builder builder = DocumentClasses.newBuilder();
			if (source.getArXivClasses()!=null && !source.getArXivClasses().isEmpty()) {
				builder.addAllArXivClasses(convertAvroToProtoBuff(source.getArXivClasses()));
			}
			if (source.getDDCClasses()!=null && !source.getDDCClasses().isEmpty()) {
				builder.addAllDdcClasses(convertAvroToProtoBuff(source.getDDCClasses()));
			}
			if (source.getWoSClasses()!=null && !source.getWoSClasses().isEmpty()) {
				builder.addAllWosClasses(convertAvroToProtoBuff(source.getWoSClasses()));
			}
			if (source.getMeshEuroPMCClasses()!=null && !source.getMeshEuroPMCClasses().isEmpty()) {
				builder.addAllMeshEuroPMCClasses(convertAvroToProtoBuff(source.getMeshEuroPMCClasses()));
			}
			return builder.build();
		} else {
			return null;
		}
	}
	
	public static List<DocumentClass> convertAvroToProtoBuff(List<eu.dnetlib.iis.documentsclassification.schemas.DocumentClass> source) {
		List<DocumentClass> result = new ArrayList<DocumentClass>();
		for (eu.dnetlib.iis.documentsclassification.schemas.DocumentClass current : source) {
			if (current!=null) {
				result.add(convertAvroToProtoBuff(current));	
			}
		}
		return result;
	}
	
	public static DocumentClass convertAvroToProtoBuff(eu.dnetlib.iis.documentsclassification.schemas.DocumentClass source) {
		if (source!=null) {
			DocumentClass.Builder builder = DocumentClass.newBuilder();
			if (source.getClassLabels()!=null) {
				for (CharSequence current : source.getClassLabels()) {
					builder.addClassLabels(current.toString());
				}
			}
			if (source.getConfidenceLevel()!=null) {
				builder.setConfidenceLevel(source.getConfidenceLevel());	
			}
			return builder.build();
		} else {
			return null;
		}
	}

}
