package eu.dnetlib.iis.export.actionmanager.module;

import java.util.Arrays;
import java.util.List;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.KindProtos.Kind;
import eu.dnetlib.data.proto.OafProtos.Oaf;
import eu.dnetlib.data.proto.OafProtos.OafRel;
import eu.dnetlib.data.proto.RelTypeProtos.RelType;
import eu.dnetlib.iis.citationmatching.schemas.Citation;
import eu.dnetlib.iis.common.hbase.HBaseConstants;

/**
 * {@link Citation} based action builder module.
 * @author mhorst
 *
 */
public class CitationActionBuilderModuleFactory 
		implements ActionBuilderFactory<Citation> {
	
	class CitationActionBuilderModule extends AbstractBuilderModule
	implements ActionBuilderModule<Citation> {
	
		private final RelType relTypeCitation = RelType.citation;
		
		/**
		 * Default constructor.
		 * @param predefinedTrust
		 * @param actionSetId
		 */
		public CitationActionBuilderModule(String predefinedTrust,
				String actionSetId) {
			super(predefinedTrust, actionSetId);
		}
	
		@Override
		public List<AtomicAction> build(Citation object, Agent agent) {
			String docId = object.getSourceDocumentId().toString();
			String currentRefId = object.getDestinationDocumentId().toString();
			Oaf.Builder oafBuilder = Oaf.newBuilder();
			oafBuilder.setKind(Kind.relation);
			OafRel.Builder relBuilder = OafRel.newBuilder();
			relBuilder.setChild(false);
			relBuilder.setRelType(relTypeCitation);
			relBuilder.setSource(docId);
			relBuilder.setTarget(currentRefId);
	//		setting citation relation semantics
			eu.dnetlib.data.proto.CitationProtos.Citation.Builder resResBuilder = eu.dnetlib.data.proto.CitationProtos.Citation.newBuilder();
			resResBuilder.setReferenceText(object.getRawText().toString());
			resResBuilder.setRelMetadata(buildRelMetadata(
					HBaseConstants.SEMANTIC_SCHEME_DNET_DATASET_PUBLICATION_RELS, 
					HBaseConstants.SEMANTIC_CLASS_REL_CITATION_CITES));
			relBuilder.setCitation(resResBuilder);
			oafBuilder.setRel(relBuilder);
			oafBuilder.setDataInfo(buildInference());
			oafBuilder.setTimestamp(System.currentTimeMillis());
			return Arrays.asList(new AtomicAction[] {
					actionFactory.createAtomicAction(
							actionSetId, agent, docId, 
							relTypeCitation.name(), 
							currentRefId, 
							oafBuilder.build().toByteArray()),
	//				setting reverse relation in referenced object
					actionFactory.createAtomicAction(
							actionSetId, agent, currentRefId, 
							relTypeCitation.name(), 
							docId,
							invertCitationRelationAndBuild(oafBuilder))				
			});
		}
	
		/**
		 * Clones builder provided as parameter, inverts relations and builds Oaf object.
		 * Sets semantics field properly according to the direction.
		 * @param existingBuilder
		 * @return Oaf object containing relation with inverted source and target fields
		 */
		private byte[] invertCitationRelationAndBuild(Oaf.Builder existingBuilder) {
	//		works on builder clone to prevent changes in existing builder
			if (existingBuilder.getRel()!=null) {
				if (existingBuilder.getRel().getSource()!=null &&
						existingBuilder.getRel().getTarget()!=null) {
					Oaf.Builder builder = existingBuilder.clone();
					OafRel.Builder relBuilder = builder.getRelBuilder();
					String source = relBuilder.getSource();
					String target = relBuilder.getTarget();
					relBuilder.setSource(target);
					relBuilder.setTarget(source);
	//				setting proper semantic class
					if (relBuilder.getResultResultBuilder()!=null &&
							relBuilder.getResultResultBuilder().getRelMetadataBuilder()!=null &&
							relBuilder.getResultResultBuilder().getRelMetadataBuilder().getSemanticsBuilder()!=null) {
						relBuilder.getResultResultBuilder().getRelMetadataBuilder().getSemanticsBuilder().setClassid(
								HBaseConstants.SEMANTIC_CLASS_REL_CITATION_CITED_BY);
						relBuilder.getResultResultBuilder().getRelMetadataBuilder().getSemanticsBuilder().setClassname(
								HBaseConstants.SEMANTIC_CLASS_REL_CITATION_CITED_BY);
					} else {
						throw new RuntimeException("unable to set proper citation semantics, " +
								"no semantics set for original citation relation!");
					}
					builder.setRel(relBuilder.build());
					builder.setTimestamp(System.currentTimeMillis());
					return builder.build().toByteArray();
				} else {
					throw new RuntimeException("invalid state: " +
							"either source or target relation was missing!");
				}
			} else {
				throw new RuntimeException("invalid state: " +
						"no relation object found!");
			}
		}

	}
	@Override
	public AlgorithmName getAlgorithName() {
		return AlgorithmName.document_referencedDocuments;
	}

	@Override
	public ActionBuilderModule<Citation> instantiate(String predefinedTrust,
			String actionSetId) {
		return new CitationActionBuilderModule(predefinedTrust, actionSetId);
	}

}
