package eu.dnetlib.iis.export.actionmanager.module;

import java.util.Collections;
import java.util.List;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.DocumentClassesProto.DocumentClasses;
import eu.dnetlib.data.proto.OafProtos.Oaf;
import eu.dnetlib.data.proto.OafProtos.OafEntity;
import eu.dnetlib.data.proto.ResultProtos.Result;
import eu.dnetlib.data.proto.TypeProtos.Type;
import eu.dnetlib.iis.documentsclassification.schemas.DocumentToDocumentClasses;
import eu.dnetlib.iis.export.actionmanager.convert.AvroToProtobufConverter;

/**
 * {@link DocumentToDocumentClasses} based action builder module.
 * @author mhorst
 *
 */
public class DocumentToDocumentClassesActionBuilderModuleFactory 
	implements ActionBuilderFactory<DocumentToDocumentClasses> {

	class DocumentToDocumentClassesActionBuilderModule extends
	AbstractBuilderModule implements ActionBuilderModule<DocumentToDocumentClasses> {

		
		/**
		 * Default constructor.
		 * @param predefinedTrust
		 * @param actionSetId
		 */
		public DocumentToDocumentClassesActionBuilderModule(
				String predefinedTrust, String actionSetId) {
			super(predefinedTrust, actionSetId);
		}
	
		@Override
		public List<AtomicAction> build(DocumentToDocumentClasses object,
				Agent agent) {
			Oaf oaf = buildOAFClasses(object);
			if (oaf!=null) {
				return actionFactory.createUpdateActions(
						actionSetId,
						agent, object.getDocumentId().toString(), Type.result, 
						oaf.toByteArray());	
			} else {
				return Collections.emptyList();
			}
		}
	
		/**
		 * Builds OAF object containing document classes.
		 * @param source
		 * @return OAF object containing document classes
		 */
		protected Oaf buildOAFClasses(DocumentToDocumentClasses source) {
			if (source.getClasses()!=null) {
				eu.dnetlib.data.proto.ResultProtos.Result.Builder resultBuilder = Result.newBuilder();
				DocumentClasses docClasses = AvroToProtobufConverter.convertAvroToProtoBuff(
						source.getClasses());
				if (docClasses!=null) {
					resultBuilder.setDocumentClasses(docClasses);
					eu.dnetlib.data.proto.OafProtos.OafEntity.Builder entityBuilder = OafEntity.newBuilder();
					if (source.getDocumentId()!=null) {
						entityBuilder.setId(source.getDocumentId().toString());	
					}
					entityBuilder.setType(Type.result);
					entityBuilder.setResult(resultBuilder.build());	
					return buildOaf(entityBuilder.build());
				}
			}
//			fallback
			return null;
		}

	}
	@Override
	public AlgorithmName getAlgorithName() {
		return AlgorithmName.document_classes;
	}

	@Override
	public ActionBuilderModule<DocumentToDocumentClasses> instantiate(
			String predefinedTrust, String actionSetId) {
		return new DocumentToDocumentClassesActionBuilderModule(
				predefinedTrust, actionSetId);
	}
}
