package eu.dnetlib.iis.export.actionmanager.module;

import java.util.List;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.CommonCoreStatisticsProto.CommonCoreStatistics;
import eu.dnetlib.data.proto.OafProtos.Oaf;
import eu.dnetlib.data.proto.OafProtos.OafEntity;
import eu.dnetlib.data.proto.ProjectProtos.Project;
import eu.dnetlib.data.proto.TypeProtos.Type;
import eu.dnetlib.iis.export.actionmanager.convert.AvroToProtobufConverter;
import eu.dnetlib.iis.statistics.schemas.ProjectToProjectStatistics;

/**
 * {@link ProjectToProjectStatistics} based action builder module.
 * @author mhorst
 *
 */
public class ProjectToProjectStatisticsActionBuilderModuleFactory 
	implements ActionBuilderFactory<ProjectToProjectStatistics> {

	class ProjectToProjectStatisticsActionBuilderModule extends AbstractBuilderModule 
	implements ActionBuilderModule<ProjectToProjectStatistics> {
		
		/**
		 * Default constructor.
		 * @param predefinedTrust
		 * @param actionSetId
		 */
		public ProjectToProjectStatisticsActionBuilderModule(
				String predefinedTrust,
				String actionSetId) {
			super(predefinedTrust, actionSetId);
		}
		
		@Override
		public List<AtomicAction> build(ProjectToProjectStatistics object, Agent agent) {
			Oaf oafObject = buildOAF(object);
			if (oafObject!=null) {
				return actionFactory.createUpdateActions(actionSetId,
								agent, object.getProjectId().toString(), 
								Type.project, oafObject.toByteArray());
			} else {
				return null;
			}
		}
		
		/**
		 * Builds OAF object.
		 * @param source
		 * @return OAF object
		 */
		protected Oaf buildOAF(ProjectToProjectStatistics source) {
			Project project = buildProjectStatistics(source);
			if (project!=null) {
				eu.dnetlib.data.proto.OafProtos.OafEntity.Builder entityBuilder = OafEntity.newBuilder();
				if (source.getProjectId()!=null) {
					entityBuilder.setId(source.getProjectId().toString());	
				}
				entityBuilder.setProject(project);
				entityBuilder.setType(Type.project);
				return buildOaf(entityBuilder.build());
			} else {
				return null;
			}
		}
		
		/**
		 * Builds project object containing statistics details.
		 * Returns null when statistics are not provided.
		 * @param source
		 * @return person object
		 */
		protected Project buildProjectStatistics(ProjectToProjectStatistics source) {
			if (source.getStatistics()!=null) {
				CommonCoreStatistics convertedStatistics = AvroToProtobufConverter.convertAvroToProtoBuff(
				source.getStatistics());
				if (convertedStatistics!=null) {
					eu.dnetlib.data.proto.ProjectProtos.Project.Builder projectBuilder = Project.newBuilder();
					projectBuilder.setStatistics(convertedStatistics);
					return projectBuilder.build();
				}
			}
	//		fallback
			return null;	
		}

	}
	
	@Override
	public AlgorithmName getAlgorithName() {
		return AlgorithmName.project_statistics;
	}

	@Override
	public ActionBuilderModule<ProjectToProjectStatistics> instantiate(
			String predefinedTrust, String actionSetId) {
		return new ProjectToProjectStatisticsActionBuilderModule(
				predefinedTrust, actionSetId);
	}

}
