package eu.dnetlib.iis.export.actionmanager.module;

import java.util.Collections;
import java.util.List;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.AuthorStatisticsProto.AuthorStatistics;
import eu.dnetlib.data.proto.OafProtos.Oaf;
import eu.dnetlib.data.proto.OafProtos.OafEntity;
import eu.dnetlib.data.proto.PersonProtos.Person;
import eu.dnetlib.data.proto.TypeProtos.Type;
import eu.dnetlib.iis.export.actionmanager.convert.AvroToProtobufConverter;
import eu.dnetlib.iis.statistics.schemas.AuthorToAuthorStatistics;

/**
 * {@link AuthorToAuthorStatistics} based action builder module.
 * @author mhorst
 *
 */
public class AuthorToAuthorStatisticsActionBuilderModuleFactory 
	implements ActionBuilderFactory<AuthorToAuthorStatistics> {

	
	class AuthorToAuthorStatisticsActionBuilderModule extends
	AbstractBuilderModule implements ActionBuilderModule<AuthorToAuthorStatistics> {
	
		/**
		 * Default constructor.
		 * @param predefinedTrust
		 * @param actionSetId
		 */
		private AuthorToAuthorStatisticsActionBuilderModule(
				String predefinedTrust,
				String actionSetId) {
			super(predefinedTrust, actionSetId);
		}
	
		@Override
		public List<AtomicAction> build(AuthorToAuthorStatistics object, Agent agent) {
			Oaf oafObject = buildOAF(object);
			if (oafObject!=null) {
				return actionFactory.createUpdateActions(actionSetId,
								agent, object.getAuthorId().toString(), 
								Type.person, oafObject.toByteArray());
				
			} else {
				return Collections.emptyList();
			}
		}
	
		/**
		 * Builds OAF object.
		 * @param source
		 * @return OAF object
		 */
		protected Oaf buildOAF(AuthorToAuthorStatistics source) {
			Person person = buildPersonStatistics(source);
			if (person!=null) {
				eu.dnetlib.data.proto.OafProtos.OafEntity.Builder entityBuilder = OafEntity.newBuilder();
				if (source.getAuthorId()!=null) {
					entityBuilder.setId(source.getAuthorId().toString());	
				}
				entityBuilder.setPerson(person);
				entityBuilder.setType(Type.person);
				return buildOaf(entityBuilder.build());
			} else {
				return null;
			}
		}
		
		/**
		 * Builds person object.
		 * Returns null when none of the following fields were provided: firstName, secondNames, fullname.
		 * @param source
		 * @return person object
		 */
		protected Person buildPersonStatistics(AuthorToAuthorStatistics source) {
			if (source.getStatistics()!=null) {
				AuthorStatistics convertedStatistics = AvroToProtobufConverter.convertAvroToProtoBuff(
				source.getStatistics());
				if (convertedStatistics!=null) {
					eu.dnetlib.data.proto.PersonProtos.Person.Builder personBuilder = Person.newBuilder();
					personBuilder.setStatistics(convertedStatistics);
					return personBuilder.build();
				}
			}
	//		fallback
			return null;	
		}
	
	}
	@Override
	public AlgorithmName getAlgorithName() {
		return AlgorithmName.person_statistics;
	}

	@Override
	public ActionBuilderModule<AuthorToAuthorStatistics> instantiate(
			String predefinedTrust, String actionSetId) {
		return new AuthorToAuthorStatisticsActionBuilderModule(
				predefinedTrust, actionSetId);
	}

}
