package eu.dnetlib.iis.export.actionmanager.module;

import java.util.Arrays;
import java.util.List;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.KindProtos.Kind;
import eu.dnetlib.data.proto.OafProtos.Oaf;
import eu.dnetlib.data.proto.OafProtos.OafRel;
import eu.dnetlib.data.proto.RelTypeProtos.RelType;
import eu.dnetlib.data.proto.ResultResultProtos.ResultResult;
import eu.dnetlib.iis.common.hbase.HBaseConstants;
import eu.dnetlib.iis.referenceextraction.dataset.schemas.DocumentToDataSet;

/**
 * {@link DocumentToDataSet} based action builder module.
 * @author mhorst
 *
 */
public class DocumentToDataSetActionBuilderModuleFactory 
		implements ActionBuilderFactory<DocumentToDataSet> {

	
	class DocumentToDataSetActionBuilderModule extends AbstractBuilderModule
	implements ActionBuilderModule<DocumentToDataSet> {
	
		private final RelType relTypeResultResult = RelType.resultResult;
		
		/**
		 * Default constructor.
		 * @param predefinedTrust
		 * @param actionSetId
		 */
		public DocumentToDataSetActionBuilderModule(String predefinedTrust,
				String actionSetId) {
			super(predefinedTrust, actionSetId);
		}
	
		@Override
		public List<AtomicAction> build(DocumentToDataSet object, Agent agent) {
			String docId = object.getDocumentId().toString();
			String currentRefId = object.getDatasetId().toString();
			Oaf.Builder oafBuilder = Oaf.newBuilder();
			oafBuilder.setKind(Kind.relation);
			OafRel.Builder relBuilder = OafRel.newBuilder();
			relBuilder.setChild(false);
			relBuilder.setRelType(relTypeResultResult);
			relBuilder.setSource(docId);
			relBuilder.setTarget(currentRefId);
			ResultResult.Builder resResultBuilder = ResultResult.newBuilder();
			resResultBuilder.setRelMetadata(buildRelMetadata(
					HBaseConstants.SEMANTIC_SCHEME_DNET_RELATIONS_RESULT_RESULT, 
					HBaseConstants.SEMANTIC_CLASS_IS_RELATED_TO));
			relBuilder.setResultResult(resResultBuilder.build());
			oafBuilder.setRel(relBuilder.build());
			oafBuilder.setDataInfo(buildInference());
			oafBuilder.setTimestamp(System.currentTimeMillis());
			return Arrays.asList(new AtomicAction[] {
					actionFactory.createAtomicAction(
						actionSetId, agent, 
						docId, 
						relTypeResultResult.name(), 
						currentRefId, 
						oafBuilder.build().toByteArray()),
	//				setting reverse relation in referenced object
					actionFactory.createAtomicAction(
						actionSetId, agent, 
						currentRefId, 
						relTypeResultResult.name(), 
						docId,
						invertRelationAndBuild(oafBuilder))
			});
		}
		
	}
	@Override
	public AlgorithmName getAlgorithName() {
		return AlgorithmName.document_referencedDatasets;
	}

	@Override
	public ActionBuilderModule<DocumentToDataSet> instantiate(
			String predefinedTrust, String actionSetId) {
		return new DocumentToDataSetActionBuilderModule(
				predefinedTrust, actionSetId);
	}
}
