package eu.dnetlib.iis.export.actionmanager.module;

import java.util.Arrays;
import java.util.List;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.KindProtos.Kind;
import eu.dnetlib.data.proto.OafProtos.Oaf;
import eu.dnetlib.data.proto.OafProtos.OafRel;
import eu.dnetlib.data.proto.RelTypeProtos.RelType;
import eu.dnetlib.data.proto.ResultProjectProtos.ResultProject;
import eu.dnetlib.iis.common.hbase.HBaseConstants;
import eu.dnetlib.iis.referenceextraction.project.schemas.DocumentToProject;

/**
 * {@link DocumentToProject} based action builder module.
 * @author mhorst
 *
 */
public class DocumentToProjectActionBuilderModuleFactory 
	implements ActionBuilderFactory<DocumentToProject> {

	class DocumentToProjectActionBuilderModule extends AbstractBuilderModule
	implements ActionBuilderModule<DocumentToProject> {
	
		private final RelType relTypeResultProject = RelType.resultProject;
		
		/**
		 * Default constructor.
		 * @param predefinedTrust
		 * @param actionSetId
		 */
		public DocumentToProjectActionBuilderModule(String predefinedTrust,
				String actionSetId) {
			super(predefinedTrust, actionSetId);
		}
	
		@Override
		public List<AtomicAction> build(DocumentToProject object, Agent agent) {
			String docId = object.getDocumentId().toString();
			String currentProjectIdStr = object.getProjectId().toString();
			Oaf.Builder oafBuilder = Oaf.newBuilder();
			oafBuilder.setKind(Kind.relation);
			OafRel.Builder relBuilder = OafRel.newBuilder();
			relBuilder.setChild(false);
			relBuilder.setRelType(relTypeResultProject);
			relBuilder.setSource(docId);
			relBuilder.setTarget(currentProjectIdStr);
			ResultProject.Builder resProjBuilder = ResultProject.newBuilder();
			resProjBuilder.setRelMetadata(buildRelMetadata(
					HBaseConstants.SEMANTIC_SCHEME_DNET_RELATIONS_RESULT_PROJECT, 
					HBaseConstants.SEMANTIC_CLASS_IS_RESULT_OF));
			relBuilder.setResultProject(resProjBuilder.build());
			oafBuilder.setRel(relBuilder.build());
			oafBuilder.setDataInfo(buildInference());
			oafBuilder.setTimestamp(System.currentTimeMillis()); 
			return Arrays.asList(new AtomicAction[] {
					actionFactory.createAtomicAction(
						actionSetId, agent, 
						docId, 
						relTypeResultProject.name(), 
						currentProjectIdStr, 
						oafBuilder.build().toByteArray()),
//				setting reverse relation in project object
				actionFactory.createAtomicAction(
						actionSetId, agent, 
						currentProjectIdStr, 
						relTypeResultProject.name(), 
						docId, 
						invertRelationAndBuild(oafBuilder))
			});
		}

	}
	@Override
	public AlgorithmName getAlgorithName() {
		return AlgorithmName.document_referencedProjects;
	}

	@Override
	public ActionBuilderModule<DocumentToProject> instantiate(
			String predefinedTrust, String actionSetId) {
		return new DocumentToProjectActionBuilderModule(
				predefinedTrust, actionSetId);
	}
}
