package eu.dnetlib.iis.export.actionmanager.module;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import eu.dnetlib.actionmanager.actions.AtomicAction;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.KindProtos.Kind;
import eu.dnetlib.data.proto.OafProtos.Oaf;
import eu.dnetlib.data.proto.OafProtos.OafRel;
import eu.dnetlib.data.proto.PersonResultProtos.PersonResult;
import eu.dnetlib.data.proto.RelTypeProtos.RelType;
import eu.dnetlib.iis.common.hbase.HBaseConstants;
import eu.dnetlib.iis.export.schemas.DocumentWithInferencedData;

/**
 * {@link DocumentWithInferencedData} based action builder module.
 * @author mhorst
 *
 */
public class DocumentWithInferencedDataActionBuilderModuleFactory implements ActionBuilderFactory<DocumentWithInferencedData> {

	class DocumentWithInferencedDataActionBuilderModule extends AbstractBuilderModule 
	implements ActionBuilderModule<DocumentWithInferencedData> {

		/**
		 * @param predefinedTrust
		 * @param actionSetId
		 */
		public DocumentWithInferencedDataActionBuilderModule(
				String predefinedTrust, String actionSetId) {
			super(predefinedTrust, actionSetId);
		}
		
		@Override
		public List<AtomicAction> build(DocumentWithInferencedData object,
				Agent agent) {
			if (object==null) {
				return null;
			}
			if (object.getId()==null) {
				throw new RuntimeException("unable to process object with null identifier");
			}
			try {
				return handleReferencedAuthors(agent,
									object.getAuthorIds(),
									object.getId().toString());	
				
			} catch (IOException e1) {
				throw new RuntimeException(e1);
			} 
		}
		
		/**
		 * Handles authors.
		 * @param agent
		 * @param authorIds
		 * @param docId
		 * @return actions with author related entries
		 * @throws IOException 
		 */
		private List<AtomicAction> handleReferencedAuthors(
				Agent agent, List<CharSequence> authorIds, 
				String docId) throws IOException {
			if (authorIds!=null && authorIds.size()>0) {
				List<AtomicAction> actions = new ArrayList<AtomicAction>();
				RelType relTypePersonResult = RelType.personResult;
				for (CharSequence authorId : authorIds) {
					String authorIdStr = authorId.toString();
					eu.dnetlib.data.proto.PersonResultProtos.PersonResult.Builder authResultBuilder = PersonResult.newBuilder();
					authResultBuilder.setRelMetadata(buildRelMetadata(
							HBaseConstants.SEMANTIC_SCHEME_DNET_PERSON_ROLES, 
							HBaseConstants.SEMANTIC_CLASS_AUTHOR));
					OafRel.Builder relBuilder = OafRel.newBuilder();
					relBuilder.setSource(docId);
					relBuilder.setTarget(authorIdStr);
					relBuilder.setRelType(relTypePersonResult);
					relBuilder.setChild(false);
					relBuilder.setPersonResult(authResultBuilder.build());
					eu.dnetlib.data.proto.OafProtos.Oaf.Builder oafBuilder = Oaf.newBuilder();
					oafBuilder.setKind(Kind.relation);
					oafBuilder.setRel(relBuilder.build());
					oafBuilder.setDataInfo(buildInference());
					oafBuilder.setTimestamp(System.currentTimeMillis());
					actions.add(actionFactory.createAtomicAction(
							actionSetId, agent, 
							docId, 
							relTypePersonResult.name(), 
							authorIdStr, 
							oafBuilder.build().toByteArray()));
//					setting reverse relation in person object
					actions.add(actionFactory.createAtomicAction(
							actionSetId, agent, 
							authorIdStr, 
							relTypePersonResult.name(), 
							docId,
							invertRelationAndBuild(oafBuilder)));
				}	
				return actions;
			} else {
				return Collections.emptyList();	
			}
		}
		
	}

	@Override
	public AlgorithmName getAlgorithName() {
//		no algorithm implemented yet
		return null;
	}

	@Override
	public ActionBuilderModule<DocumentWithInferencedData> instantiate(
			String predefinedTrust, String actionSetId) {
		// TODO Auto-generated method stub
		return new DocumentWithInferencedDataActionBuilderModule(
				predefinedTrust, actionSetId);
	}
}
