/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collective.transformation.engine.functions;

import eu.dnetlib.common.profile.Resource;
import eu.dnetlib.common.utils.XMLUtils;
import eu.dnetlib.data.collective.transformation.engine.functions.IVocabulary;
import eu.dnetlib.data.collective.transformation.engine.functions.ProcessingException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.dom4j.Node;

public class Vocabulary
implements IVocabulary {
    private List<Term> terms;
    private Map<String, String> encodingMap;
    private Resource resource;
    private boolean isCaseSensitive = true;
    private String delimiter = null;
    private String name = null;

    public List<Term> getTerms() {
        return this.terms;
    }

    public void setTerms(List<Term> terms) {
        this.terms = terms;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVocabularyName() {
        return this.resource.getValue("//VOCABULARY_NAME");
    }

    @Override
    public String encoding(List<String> keys) throws ProcessingException {
        for (String key : keys) {
            key = key.trim();
            if (!this.isCaseSensitive) {
                key = key.toLowerCase();
            }
            if (!this.encodingMap.containsKey(key)) continue;
            return this.encodingMap.get(key);
        }
        if (this.encodingMap.containsKey("Unknown") || this.encodingMap.containsKey("unknown")) {
            if (this.isCaseSensitive) {
                return this.encodingMap.get("Unknown");
            }
            return this.encodingMap.get("unknown");
        }
        if (this.isCaseSensitive) {
            return this.encodingMap.get("Undetermined");
        }
        return this.encodingMap.get("undetermined");
    }

    public void setResource(List<Map<String, ?>> aTermList) {
        this.terms = new LinkedList<Term>();
        for (Map<String, ?> termMap : aTermList) {
            Term t = new Term();
            this.terms.add(t);
            t.name = (String)termMap.get("name");
            t.code = (String)termMap.get("code");
            for (String synonym : (List)termMap.get("synonyms")) {
                t.addSynonym(synonym);
            }
        }
        this.setCode();
    }

    public void setResource(Resource resource) {
        this.resource = resource;
        this.terms = new LinkedList<Term>();
        List<Node> nodes = resource.getNodeList("//TERMS/*");
        int index = 1;
        for (Node n : nodes) {
            Term t = new Term();
            this.terms.add(t);
            try {
                t.name = XMLUtils.getNode(n, "//TERM[" + index + "]/@english_name").getText();
                t.code = XMLUtils.getNode(n, "//TERM[" + index + "]/@code").getText();
                List<Node> nsynonyms = XMLUtils.getNodes(n, "//TERM[" + index + "]/SYNONYMS/*");
                int indexSynonyms = 1;
                for (Node nsynonym : nsynonyms) {
                    String synonymTerm = XMLUtils.getNode(nsynonym, "//TERM[" + index + "]//SYNONYM[" + indexSynonyms + "]/@term").getText();
                    t.addSynonym(synonymTerm);
                    ++indexSynonyms;
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            ++index;
        }
        this.setCode();
    }

    private void setCode() {
        this.encodingMap = new TreeMap<String, String>();
        for (Term t : this.terms) {
            if (this.isCaseSensitive) {
                this.encodingMap.put(t.name, t.code);
                this.encodingMap.put(t.code, t.code);
            } else {
                this.encodingMap.put(t.name.toLowerCase(), t.code);
                this.encodingMap.put(t.code.toLowerCase(), t.code);
            }
            if (this.delimiter != null) {
                String[] splittedEncodings;
                for (String encoding : splittedEncodings = t.code.split(this.delimiter)) {
                    if (this.isCaseSensitive) {
                        this.encodingMap.put(encoding, t.code);
                        continue;
                    }
                    this.encodingMap.put(encoding.toLowerCase(), t.code);
                }
            }
            for (String synonym : t.synonyms) {
                if (this.isCaseSensitive) {
                    this.encodingMap.put(synonym, t.code);
                    continue;
                }
                this.encodingMap.put(synonym.toLowerCase(), t.code);
            }
        }
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    @Override
    public List<String> encoding(List<String> aKeys, String aDefaultPattern, String aFilterFunction) throws ProcessingException {
        throw new ProcessingException("no implementation of filtered encoding.");
    }

    class Term {
        String code;
        String name;
        List<String> synonyms = new LinkedList<String>();

        Term() {
        }

        void addSynonym(String synonym) {
            this.synonyms.add(synonym);
        }

        List<String> getSynonyms() {
            return this.synonyms;
        }
    }
}

