package eu.dnetlib.data.collective.transformation;

import org.dom4j.DocumentException;

import eu.dnetlib.data.collective.transformation.engine.functions.DateVocabulary;
import eu.dnetlib.data.collective.transformation.engine.functions.IVocabulary;
import eu.dnetlib.data.collective.transformation.engine.functions.PersonVocabulary;
//import eu.dnetlib.data.collective.transformation.engine.functions.PmcVocabulary;
import eu.dnetlib.data.collective.transformation.engine.functions.Vocabulary;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;

/**
 * @author jochen
 *
 */
public class VocabularyRegistry {

	private static final String dateVocabularyName = "DateISO8601";
//	private static final String pmcVocabularyName = "PMC";
	private static final String personVocabularyName = "Person";
	
	ServiceLocator<ISLookUpService> lookupLocator;
	private VocabularyMap vocabularies;
	private boolean isInitialized = false;
	
	public void init(){
		String vocabularyQueryPrefix = "collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType')//RESOURCE_PROFILE";
		
		for (String key: vocabularies.getMap().keySet()){
			try {
				Vocabulary v = vocabularies.getMap().get(key);
				v.setResource(new eu.dnetlib.common.profile.Resource(
						lookupLocator.getService().getResourceProfileByQuery(
								vocabularyQueryPrefix + "[.//VOCABULARY_NAME='" + vocabularies.getMap().get(key).getName() + "']")));
			} catch (ISLookUpDocumentNotFoundException e) {
				throw new IllegalStateException("vocabulary profile not found for name " + vocabularies.getMap().get(key).getName(), e);
			} catch (ISLookUpException e) {
				throw new IllegalStateException(e);
			} catch (DocumentException e) {
				throw new IllegalStateException(e);
			}
		}
		vocabularies.getMap().put(dateVocabularyName, new DateVocabulary());
		vocabularies.getMap().put(personVocabularyName, new PersonVocabulary());
//		PmcVocabulary pmcVocab = new PmcVocabulary();
//		pmcVocab.setMappingFile(mappingFile);
//		vocabularies.getMap().put(pmcVocabularyName, pmcVocab);
		isInitialized = true;
	}
	
	public IVocabulary getVocabulary(String aVocabularyName){
		if (!isInitialized) init();
		return vocabularies.getMap().get(aVocabularyName);
	}
	
	public VocabularyMap getVocabularies() {
		if (!isInitialized) init();
		return vocabularies;
	}

	public void setVocabularies(VocabularyMap vocabularies) {
		this.vocabularies = vocabularies;
	}
	
	public void addVocabulary(String aVocabularyName, Vocabulary aVocabulary){
		this.vocabularies.getMap().put(aVocabularyName, aVocabulary);
	}
	
	public void removeVocabulary(String aVocabulary){
		 this.vocabularies.getMap().remove(aVocabulary);
	}
	
	public ServiceLocator<ISLookUpService> getLookupLocator() {
		return lookupLocator;
	}

	public void setLookupLocator(
			ServiceLocator<ISLookUpService> lookupServiceLocator) {
		this.lookupLocator = lookupServiceLocator;
	}


}
