package eu.dnetlib.data.collective.transformation.core.schema.visitor;

import java.util.Collection;
import java.util.Iterator;

import org.apache.commons.lang.NotImplementedException;


import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.visitor.XSContentTypeVisitor;
import com.sun.xml.xsom.visitor.XSVisitor;

import eu.dnetlib.data.collective.transformation.core.schema.SchemaAttribute;
import eu.dnetlib.data.collective.transformation.core.schema.SchemaElement;

/**
 * @author jochen
 *
 */
public class XSContentTypeVisitorImpl implements XSContentTypeVisitor {

	private Visitor visitor;
	
	@Override
	public void empty(XSContentType arg0) {
		throw new NotImplementedException();
	}

	@Override
	public void particle(XSParticle aParticle) {
		XSTermVisitorImpl termVisitor = new XSTermVisitorImpl();
		termVisitor.setVisitor(this.visitor);
		aParticle.getTerm().visit(termVisitor);		
		if (aParticle.getTerm().isElementDecl()){
			XSElementDecl elem = aParticle.getTerm().asElementDecl();						
			SchemaElement element = new SchemaElement();

			XSType type = elem.getType();
			if (type.isComplexType()){
				System.out.println("complextype: contentype-visitor: element name: " + elem.getName());
				Collection<? extends XSAttributeUse> attrColls = 
						type.asComplexType().getDeclaredAttributeUses();
				Iterator<? extends XSAttributeUse> attrIter = attrColls.iterator();
				while (attrIter.hasNext()){
					XSAttributeUse attrUse = attrIter.next();
					SchemaAttribute attribute = new SchemaAttribute();
					attribute.setName(attrUse.getDecl().getName());
					attribute.setRequired(attrUse.isRequired());
					element.addAttribute(attribute);
					System.out.println("attribute Name: " + attrUse.getDecl().getName());
					System.out.println("attribute required: " + attrUse.isRequired());
					
				}
			}else if(type.isSimpleType()){
				System.out.println("simpletype: contentype-visitor: element name: " + elem.getName());				
			}
			element.setName(elem.getName());
			element.setTargetNamespace(elem.getTargetNamespace());
			element.setMinOccurs(aParticle.getMinOccurs());
			element.setMaxOccurs(aParticle.getMaxOccurs());
			element.setRepeatable(aParticle.isRepeated());
			
			if (elem.getType().isComplexType()){
				if (elem.getType().asComplexType().getContentType().asSimpleType() != null){
					element.setContainsSimpleType(true);
				}
			}			
			this.visitor.getCurrentElement().getChildList().add(element);
		}
	}

	@Override
	public void simpleType(XSSimpleType arg0) {
		throw new NotImplementedException();
	}

	public void setVisitor(Visitor visitor) {
		this.visitor = visitor;
	}

	public Visitor getVisitor() {
		return visitor;
	}

}

