/**
 * 
 */
package eu.dnetlib.data.collective.transformation.engine.functions;

import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;

import eu.dnetlib.common.profile.Resource;
import eu.dnetlib.common.profile.ResourceDao;
import eu.dnetlib.data.collective.transformation.rulelanguage.Argument;

/**
 * @author jochen
 *
 */
public class RetrieveValue extends AbstractTransformationFunction {

	public static final Log log = LogFactory.getLog(RetrieveValue.class);
	public static final String paramFunctionName = "functionName";
	public static final String paramFunctionProfileId = "functionParameterProfileId";
	public static final String paramFunctionExpr = "functionParameterExpr";
	
	public enum FUNCTION {PROFILEFIELD, CURRENTDATE};
	
	@javax.annotation.Resource
	private ResourceDao resourceDao;
		
	/* (non-Javadoc)
	 * @see eu.dnetlib.data.collective.transformation.engine.functions.AbstractTransformationFunction#execute()
	 */
	@Override
	String execute() throws ProcessingException {
		// TODO Auto-generated method stub
		return null;
	}
	
	public String executeSingleValue(String functionName, List<Argument> arguments, String objRecord, Map<String, String> namespaceMap) throws ProcessingException, DocumentException{
		String result = "";
		FUNCTION function = FUNCTION.valueOf(functionName);
		
		switch(function){
		case PROFILEFIELD:
			if (arguments.size() != 2){
				throw new ProcessingException("invalid number of arguments - required 2 but found :" + arguments.size());
			}
			String profileId = "";
			log.debug("RETRIEVEVALUE: " + arguments.get(0).getArgument());
			if (arguments.get(0).isValue()){
				profileId = arguments.get(0).getArgument();
			}else if (arguments.get(0).isInputField()){
				profileId = evaluateXpath(objRecord, arguments.get(0).getArgument(), namespaceMap);
			}else if (arguments.get(0).isJobConst()){
				// TODO
			}else if (arguments.get(0).isVariable()){
				// TODO
			}
			Resource resource = resourceDao.getResource(profileId); // profile id
			if (resource == null){
				throw new ProcessingException("invalid profileId: " + profileId + "; functionName: " + functionName + ", arg1: " + arguments.get(0).getArgument() + ", arg2: " + arguments.get(1).getArgument());
			}
			result = resource.getValue(arguments.get(1).getArgument());  // xpath expr
			break;
		case CURRENTDATE:
			SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'"); // TODO format string
			result = dateFormat.format(new Date());
			default:
				// unsupported
				break;
		}
		return result;
	}

	/**
	 * @return the resourceDao
	 */
	public ResourceDao getResourceDao() {
		return resourceDao;
	}

	/**
	 * @param resourceDao the resourceDao to set
	 */
	public void setResourceDao(ResourceDao resourceDao) {
		this.resourceDao = resourceDao;
	}

	private String evaluateXpath(String record, String xpathExpr, Map<String, String> nsMap) throws DocumentException{
		SAXReader reader = new SAXReader();
        Document doc = reader.read(new StringReader(record));
		XPath xpath =  DocumentHelper.createXPath(xpathExpr);
		xpath.setNamespaceURIs(nsMap);
		return xpath.valueOf(doc);
	}
}
