/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collective.transformation.core.xsl;

import eu.dnetlib.data.collective.transformation.core.xsl.XslElement;
import eu.dnetlib.data.collective.transformation.rulelanguage.Rules;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XslConstructor {
    private static final Log log = LogFactory.getLog(XslConstructor.class);

    public String writeOutVariableRule(Rules rule) {
        XslElement xsltVariable = new XslElement("xsl:param");
        xsltVariable.addAttribute("name", rule.getUniqueName().substring(1));
        if (rule.getXpath().length() > 0) {
            xsltVariable.addAttribute("select", rule.getXpath());
        } else if (rule.getFunctionCall() != null) {
            if (rule.getFunctionCall().doPreprocess()) {
                xsltVariable.addAttribute("select", rule.getFunctionCall().getXSLpreparatedFunctionCall());
            } else {
                xsltVariable.addAttribute("select", rule.getFunctionCall().getXSLdirectFunctionCall(null));
            }
        } else if (rule.getConstant().length() > 0) {
            xsltVariable.addAttribute("select", rule.getConstant());
        }
        return xsltVariable.asXml();
    }

    public String writeOutConditionalChooseComplex(Rules rule) {
        XslElement choose = new XslElement("xsl:choose");
        XslElement when = new XslElement("xsl:when");
        log.debug((Object)("XslConstructor: conditionExpresssion: " + rule.getCondition().getConditionExpression()));
        when.addAttribute("test", rule.getCondition().getConditionExpression());
        when.addEnclosedElements(this.writeOutRuleComplex(rule.getCondition().getPrimaryRule(), rule.getCondition().getPrimaryRule().getUniqueName()));
        choose.addEnclosedElements(when.asXml());
        XslElement otherwise = new XslElement("xsl:otherwise");
        otherwise.addEnclosedElements(this.writeOutRuleComplex(rule.getCondition().getSecondaryRule(), rule.getCondition().getSecondaryRule().getUniqueName()));
        choose.addEnclosedElements(otherwise.asXml());
        return choose.asXml();
    }

    public String writeOutConditionalIfComplex(Rules rule) {
        XslElement ifCondition = new XslElement("xsl:if");
        if (rule.getCondition().isPrimary(rule)) {
            ifCondition.addAttribute("test", rule.getCondition().getConditionExpression());
            ifCondition.addEnclosedElements(this.writeOutRuleComplex(rule.getCondition().getPrimaryRule(), rule.getCondition().getPrimaryRule().getUniqueName()));
        } else {
            ifCondition.addAttribute("test", "not(" + rule.getCondition().getConditionExpression() + ")");
            ifCondition.addEnclosedElements(this.writeOutRuleComplex(rule.getCondition().getPrimaryRule(), rule.getCondition().getPrimaryRule().getUniqueName()));
        }
        return ifCondition.asXml();
    }

    public String writeOutRuleComplex(Rules rule, String targetFieldName) {
        XslElement valueOf;
        XslElement targetField = new XslElement(targetFieldName);
        if (rule.hasSet()) {
            for (Rules attrRule : rule.getRulesSet().getPendingRules()) {
                XslElement valueOf2;
                XslElement attr;
                if (attrRule.getConstant().length() > 0) {
                    targetField.addAttribute(attrRule.getAttribute(), attrRule.getConstant());
                    continue;
                }
                if (attrRule.getAssignmentVariable().length() > 0) {
                    attr = new XslElement("xsl:attribute");
                    attr.addAttribute("name", attrRule.getAttribute());
                    valueOf2 = new XslElement("xsl:value-of", "select", attrRule.getAssignmentVariable());
                    attr.addEnclosedElements(valueOf2.asXml());
                    targetField.addEnclosedElements(attr.asXml());
                    continue;
                }
                if (attrRule.getXpath().length() > 0) {
                    attr = new XslElement("xsl:attribute");
                    attr.addAttribute("name", attrRule.getAttribute());
                    valueOf2 = new XslElement("xsl:value-of", "select", attrRule.getXpath());
                    attr.addEnclosedElements(valueOf2.asXml());
                    targetField.addEnclosedElements(attr.asXml());
                    continue;
                }
                log.debug((Object)("name of the rule in writeOutRuleComplex: " + rule.getUniqueName() + " " + attrRule.getAttribute()));
                XslElement valueOf3 = attrRule.getFunctionCall().doPreprocess() ? new XslElement("xsl:value-of", "select", attrRule.getFunctionCall().getXSLpreparatedFunctionCall()) : new XslElement("xsl:value-of", "select", attrRule.getFunctionCall().getXSLdirectFunctionCall(null));
                XslElement attr2 = new XslElement("xsl:attribute");
                attr2.addAttribute("name", attrRule.getAttribute());
                attr2.addEnclosedElements(valueOf3.asXml());
                targetField.addEnclosedElements(attr2.asXml());
            }
            log.debug((Object)targetField.asXml());
        }
        log.debug((Object)("unique name of rule: " + rule.getUniqueName()));
        if (rule.getXpath().length() > 0) {
            valueOf = new XslElement("xsl:value-of", "select", ".");
            XslElement forEach = new XslElement("xsl:for-each");
            forEach.addAttribute("select", rule.getXpath());
            targetField.addEnclosedElements(valueOf.asXml());
            forEach.addEnclosedElements(targetField.asXml());
            return forEach.asXml();
        }
        if (rule.getAssignmentVariable().length() > 0) {
            log.debug((Object)("assignmentVar: " + rule.getAssignmentVariable()));
            valueOf = new XslElement("xsl:value-of", "select", rule.getAssignmentVariable());
            targetField.addEnclosedElements(valueOf.asXml());
            log.debug((Object)targetField.asXml());
        } else if (rule.getConstant().length() > 0) {
            throw new IllegalStateException("complex rule with Constant Assignment not yet implemented");
        }
        return targetField.asXml();
    }

    public String writeOutRule(Rules rule, String targetFieldName) {
        if (rule.getXpath().length() > 0) {
            XslElement valueOf = new XslElement("xsl:value-of", "select", ".");
            XslElement forEach = new XslElement("xsl:for-each");
            forEach.addAttribute("select", rule.getXpath());
            XslElement targetField = new XslElement(targetFieldName);
            targetField.addEnclosedElements(valueOf.asXml());
            forEach.addEnclosedElements(targetField.asXml());
            return forEach.asXml();
        }
        if (rule.getConstant().length() > 0) {
            XslElement xslText = new XslElement("xsl:text");
            xslText.addEnclosedElements(rule.getConstant());
            XslElement targetField = new XslElement(targetFieldName);
            targetField.addEnclosedElements(xslText.asXml());
            return targetField.asXml();
        }
        if (rule.getAssignmentVariable().length() > 0) {
            XslElement targetField = new XslElement(targetFieldName);
            XslElement valueOf = new XslElement("xsl:value-of", "select", rule.getAssignmentVariable());
            targetField.addEnclosedElements(valueOf.asXml());
            return targetField.asXml();
        }
        if (rule.isEmpty()) {
            XslElement targetField = new XslElement(targetFieldName);
            return targetField.asXml();
        }
        XslElement valueOf = rule.getFunctionCall().doPreprocess() ? new XslElement("xsl:value-of", "select", rule.getFunctionCall().getXSLpreparatedFunctionCall()) : new XslElement("xsl:value-of", "select", rule.getFunctionCall().getXSLdirectFunctionCall(null));
        XslElement targetField = new XslElement(targetFieldName);
        targetField.addEnclosedElements(valueOf.asXml());
        return targetField.asXml();
    }

    public String writeOutConditionalChoose(Rules rule) {
        XslElement choose = new XslElement("xsl:choose");
        XslElement when = new XslElement("xsl:when");
        when.addAttribute("test", rule.getCondition().getConditionExpression());
        when.addEnclosedElements(this.writeOutRule(rule.getCondition().getPrimaryRule(), rule.getCondition().getPrimaryRule().getUniqueName()));
        choose.addEnclosedElements(when.asXml());
        XslElement otherwise = new XslElement("xsl:otherwise");
        otherwise.addEnclosedElements(this.writeOutRule(rule.getCondition().getSecondaryRule(), rule.getCondition().getSecondaryRule().getUniqueName()));
        choose.addEnclosedElements(otherwise.asXml());
        return choose.asXml();
    }

    public String writeOutConditionalIf(Rules rule) {
        XslElement ifCondition = new XslElement("xsl:if");
        if (rule.getCondition().isPrimary(rule)) {
            ifCondition.addAttribute("test", rule.getCondition().getConditionExpression());
            ifCondition.addEnclosedElements(this.writeOutRule(rule, rule.getTargetField()));
        } else {
            ifCondition.addAttribute("test", "not(" + rule.getCondition().getConditionExpression() + ")");
            ifCondition.addEnclosedElements(this.writeOutRule(rule, rule.getTargetField()));
        }
        return ifCondition.asXml();
    }

    public String writeOutCallTemplate(String aTemplateName) {
        XslElement callTemplate = new XslElement("xsl:call-template", "name", aTemplateName);
        return callTemplate.asXml();
    }

    public String writeOutApplyConditionalTemplateChoose(Rules rule) {
        XslElement forEach = new XslElement("xsl:for-each");
        forEach.addAttribute("select", rule.getCondition().getApplyExpression());
        XslElement choose = new XslElement("xsl:choose");
        XslElement when = new XslElement("xsl:when");
        when.addAttribute("test", rule.getCondition().getConditionExpression());
        XslElement targetField = new XslElement(rule.getCondition().getPrimaryRule().getTargetField());
        XslElement valueOf = null;
        Rules pRule = rule.getCondition().getPrimaryRule();
        valueOf = pRule.getFunctionCall() != null ? (pRule.getFunctionCall().doPreprocess() ? new XslElement("xsl:value-of", "select", pRule.getFunctionCall().getXSLpreparatedFunctionCall()) : new XslElement("xsl:value-of", "select", pRule.getFunctionCall().getXSLdirectFunctionCall(null))) : new XslElement("xsl:value-of", "select", pRule.getXpath());
        targetField.addEnclosedElements(valueOf.asXml());
        when.addEnclosedElements(targetField.asXml());
        choose.addEnclosedElements(when.asXml());
        XslElement otherwise = new XslElement("xsl:otherwise");
        targetField = new XslElement(rule.getCondition().getSecondaryRule().getTargetField());
        Rules sRule = rule.getCondition().getSecondaryRule();
        valueOf = sRule.getFunctionCall() != null ? (sRule.getFunctionCall().doPreprocess() ? new XslElement("xsl:value-of", "select", sRule.getFunctionCall().getXSLpreparatedFunctionCall()) : new XslElement("xsl:value-of", "select", sRule.getFunctionCall().getXSLdirectFunctionCall(null))) : new XslElement("xsl:value-of", "select", sRule.getXpath());
        targetField.addEnclosedElements(valueOf.asXml());
        otherwise.addEnclosedElements(targetField.asXml());
        choose.addEnclosedElements(otherwise.asXml());
        return forEach.asXml();
    }

    public String writeOutApplyConditionalTemplateIf(Rules rule, boolean isComplexStructure) {
        XslElement forEach = new XslElement("xsl:for-each");
        forEach.addAttribute("select", rule.getCondition().getApplyExpression());
        XslElement posVar = new XslElement("xsl:variable");
        posVar.addAttribute("name", "posVar");
        posVar.addAttribute("select", "position()");
        forEach.addEnclosedElements(posVar.asXml());
        XslElement ifCondition = new XslElement("xsl:if");
        if (rule.getCondition().isPrimary(rule)) {
            ifCondition.addAttribute("test", rule.getCondition().getConditionExpression());
            Rules pRule = rule.getCondition().getPrimaryRule();
            if (isComplexStructure) {
                ifCondition.addEnclosedElements(this.writeOutRuleComplex(pRule, pRule.getUniqueName()));
            } else {
                XslElement targetField = new XslElement(pRule.getTargetField());
                XslElement valueOf = null;
                valueOf = pRule.getFunctionCall() != null ? (pRule.getFunctionCall().doPreprocess() ? new XslElement("xsl:value-of", "select", pRule.getFunctionCall().getXSLpositionFunctionCall()) : new XslElement("xsl:value-of", "select", pRule.getFunctionCall().getXSLdirectFunctionCall(null))) : new XslElement("xsl:value-of", "select", pRule.getXpath());
                targetField.addEnclosedElements(valueOf.asXml());
                ifCondition.addEnclosedElements(targetField.asXml());
            }
            forEach.addEnclosedElements(ifCondition.asXml());
        } else {
            ifCondition.addAttribute("test", "not(" + rule.getCondition().getConditionExpression() + ")");
            Rules sRule = rule.getCondition().getSecondaryRule();
            if (isComplexStructure) {
                ifCondition.addEnclosedElements(this.writeOutRuleComplex(sRule, sRule.getUniqueName()));
            } else {
                XslElement targetField = new XslElement(sRule.getTargetField());
                XslElement valueOf = null;
                valueOf = sRule.getFunctionCall() != null ? (sRule.getFunctionCall().doPreprocess() ? new XslElement("xsl:value-of", "select", sRule.getFunctionCall().getXSLpositionFunctionCall()) : new XslElement("xsl:value-of", "select", sRule.getFunctionCall().getXSLdirectFunctionCall(null))) : new XslElement("xsl:value-of", "select", sRule.getXpath());
                targetField.addEnclosedElements(valueOf.asXml());
                ifCondition.addEnclosedElements(targetField.asXml());
            }
            forEach.addEnclosedElements(ifCondition.asXml());
        }
        return forEach.asXml();
    }

    public XslElement writeOutRecursiveTemplate(Rules rule, String templateName, Map<String, String> nsDeclarations) {
        XslElement subTemplate = new XslElement("xsl:template", "name", templateName);
        XslElement param = new XslElement("xsl:param");
        param.addAttribute("name", templateName + "param");
        param.addAttribute("select", rule.getFunctionCall().getXSLdirectFunctionCall(templateName));
        subTemplate.addEnclosedElements(param.asXml());
        XslElement testParam = new XslElement("xsl:if", "test", "$" + templateName + "param");
        XslElement element = new XslElement("xsl:element");
        String targetElementName = rule.getFunctionCall().getParameters().get("elementName");
        String namespace = "";
        if (targetElementName.contains(":")) {
            String[] nameSplitting = targetElementName.split(":");
            targetElementName = nameSplitting[1];
            namespace = nsDeclarations.get(nameSplitting[0]);
        }
        element.addAttribute("name", targetElementName);
        element.addAttribute("namespace", namespace);
        element.addAttribute("inherit-namespaces", "yes");
        XslElement valueOf = new XslElement("xsl:value-of", "select", "$" + templateName + "param");
        element.addEnclosedElements(valueOf.asXml());
        testParam.addEnclosedElements(element.asXml());
        XslElement callTemplate = new XslElement("xsl:call-template", "name", templateName);
        XslElement withParam = new XslElement("xsl:with-param", "name", templateName + "param");
        withParam.addAttribute("select", rule.getFunctionCall().getXSLdirectFunctionCallById(templateName));
        callTemplate.addEnclosedElements(withParam.asXml());
        testParam.addEnclosedElements(callTemplate.asXml());
        subTemplate.addEnclosedElements(testParam.asXml());
        return subTemplate;
    }
}

