/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collective.transformation.engine.core;

import eu.dnetlib.data.collective.transformation.TransformationException;
import eu.dnetlib.data.collective.transformation.core.schema.SchemaInspector;
import eu.dnetlib.data.collective.transformation.engine.core.ITransformation;
import eu.dnetlib.data.collective.transformation.engine.core.StylesheetBuilder;
import eu.dnetlib.data.collective.transformation.rulelanguage.RuleLanguageParser;
import eu.dnetlib.data.collective.transformation.rulelanguage.Rules;
import eu.dnetlib.data.collective.transformation.utils.NamespaceContextImpl;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class TransformationImpl
implements ITransformation {
    private static final String rootElement = "record";
    private final Log log = LogFactory.getLog(TransformationImpl.class);
    private Document xslDoc;
    private SAXReader reader = new SAXReader();
    private TransformerFactory tf;
    private Transformer t;
    protected RuleLanguageParser ruleLanguageParser;
    private StylesheetBuilder stylesheetBuilder;
    private Map<String, String> staticResults = new LinkedHashMap<String, String>();
    private Map<String, String> jobConstantMap = new HashMap<String, String>();
    @Resource(name="template")
    private org.springframework.core.io.Resource template;
    private org.springframework.core.io.Resource schema;

    public void init() {
        try {
            this.xslDoc = this.reader.read(this.template.getInputStream());
        }
        catch (Throwable e) {
            this.log.error((Object)"cannot initialize this transformation.", e);
            throw new IllegalStateException(e);
        }
    }

    public void addJobConstant(String aKey, String aValue) {
        this.jobConstantMap.put(aKey, aValue);
    }

    public void configureTransformation() throws TransformerConfigurationException {
        this.tf = TransformerFactory.newInstance();
        Templates templ = this.ruleLanguageParser.isXslStylesheet() ? this.tf.newTemplates(new StreamSource(new StringReader(this.ruleLanguageParser.getXslStylesheet()))) : this.tf.newTemplates(new StreamSource(this.createStylesheet()));
        this.t = templ.newTransformer();
        this.t.setOutputProperty("indent", "yes");
        this.t.setOutputProperty("method", "xml");
        this.t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
    }

    @Override
    public String transformRecord(String record, int index) throws TransformationException {
        try {
            StreamSource s = new StreamSource(new StringReader(record));
            StringWriter writer = new StringWriter();
            StreamResult r = new StreamResult(writer);
            this.t.setParameter("index", index);
            this.t.transform(s, r);
            return writer.toString();
        }
        catch (TransformerException e) {
            this.log.error((Object)e);
            throw new TransformationException(e);
        }
    }

    public String dumpStylesheet() {
        StringWriter writer = new StringWriter();
        try {
            Transformer tXsl = this.tf.newTransformer();
            tXsl.setOutputProperty("indent", "yes");
            tXsl.setOutputProperty("method", "xml");
            tXsl.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StreamResult r = new StreamResult(writer);
            StreamSource s = new StreamSource(new StringReader(this.xslDoc.asXML()));
            tXsl.transform(s, r);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return writer.toString();
    }

    public void setTemplate(org.springframework.core.io.Resource template) {
        this.template = template;
    }

    public org.springframework.core.io.Resource getTemplate() {
        return this.template;
    }

    public void setRuleLanguageParser(RuleLanguageParser ruleLanguageParser) {
        this.ruleLanguageParser = ruleLanguageParser;
    }

    @Override
    public RuleLanguageParser getRuleLanguageParser() {
        return this.ruleLanguageParser;
    }

    public void setStylesheetBuilder(StylesheetBuilder stylesheetBuilder) {
        this.stylesheetBuilder = stylesheetBuilder;
    }

    public StylesheetBuilder getStylesheetBuilder() {
        return this.stylesheetBuilder;
    }

    protected String getTransformationRules() {
        for (String key : this.jobConstantMap.keySet()) {
            Rules r = new Rules();
            r.setVariable(key);
            r.setConstant("'" + this.jobConstantMap.get(key) + "'");
            this.ruleLanguageParser.getVariableMappingRules().put("$job.datasinkid", r);
        }
        if (this.stylesheetBuilder == null) {
            this.stylesheetBuilder = new StylesheetBuilder();
            this.stylesheetBuilder.setRuleLanguageParser(this.ruleLanguageParser);
            NamespaceContextImpl namespaceContext = new NamespaceContextImpl();
            for (String prefix : this.ruleLanguageParser.getNamespaceDeclarations().keySet()) {
                namespaceContext.addNamespace(prefix, this.ruleLanguageParser.getNamespaceDeclarations().get(prefix));
            }
            SchemaInspector inspector = new SchemaInspector();
            try {
                inspector.inspect(this.schema.getURL(), rootElement);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            this.stylesheetBuilder.setNamespaceContext(namespaceContext);
            this.stylesheetBuilder.setSchemaInspector(inspector);
        }
        return this.stylesheetBuilder.createTemplate();
    }

    private Reader createStylesheet() {
        try {
            Document rulesDoc = DocumentHelper.parseText((String)this.getTransformationRules());
            for (String key : this.ruleLanguageParser.getNamespaceDeclarations().keySet()) {
                this.xslDoc.getRootElement().addNamespace(key, this.ruleLanguageParser.getNamespaceDeclarations().get(key));
            }
            List nodes = rulesDoc.getRootElement().selectNodes("//xsl:template");
            List varNodes = rulesDoc.getRootElement().selectNodes("/templateroot/xsl:param");
            for (Node node : varNodes) {
                this.xslDoc.getRootElement().add(((Element)node).detach());
            }
            for (Node node : nodes) {
                this.xslDoc.getRootElement().add(((Element)node).detach());
            }
        }
        catch (DocumentException e) {
            this.log.error((Object)("error in creating stylesheet: " + (Object)((Object)e)));
            throw new IllegalStateException(e);
        }
        return new StringReader(this.xslDoc.asXML());
    }

    public void setSchema(org.springframework.core.io.Resource schema) {
        this.schema = schema;
    }

    public org.springframework.core.io.Resource getSchema() {
        return this.schema;
    }

    @Override
    public Map<String, String> getStaticTransformationResults() {
        return this.staticResults;
    }

    @Override
    public Map<String, String> getJobProperties() {
        return this.jobConstantMap;
    }

    @Override
    public Properties getLogInformation() {
        return null;
    }
}

