<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dri="http://www.driver-repository.eu/namespace/dri" xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:esf="http://schemas.espas-fp7.eu" version="2.0">
	<xsl:output method="xml" indent="yes" encoding="UTF-8"/>
	<xsl:template match="/">
		<result type="observation">
			<xsl:apply-templates select="//header"/>
			<xsl:apply-templates select="//metadata"/>
		</result>
	</xsl:template>

	<xsl:template match="header">
		<field name="objIdentifier" multiplicity="false" indexId="objIdentifier" label="Observation id">
			<xsl:attribute name="value">
				<xsl:value-of select="./dri:objIdentifier"/>
			</xsl:attribute>
		</field>
	</xsl:template>

	<xsl:template match="metadata">

		<field name="startdate" multiplicity="false" indexId="startdate" label="Start Date">
			<xsl:attribute name="value">
				<xsl:value-of select="./esf:startdate"/>
			</xsl:attribute>
		</field>

		<field name="enddate" multiplicity="false" indexId="enddate" label="End Date">
			<xsl:attribute name="value">
				<xsl:value-of select="./esf:enddate"/>
			</xsl:attribute>
		</field>

		<field name="seconds" multiplicity="false" indexId="seconds" label="Seconds">
			<xsl:attribute name="value">
				<xsl:value-of select="./esf:seconds"/>
			</xsl:attribute>
		</field>

		<xsl:for-each select="./esf:year">
			<field name="year" multiplicity="true" indexId="year" label="Year">
				<xsl:attribute name="value">
					<xsl:value-of select="."/>
				</xsl:attribute>
			</field>
		</xsl:for-each>

		<xsl:for-each select="./esf:results">
			<field name="results" multiplicity="true" indexId="results" label="Results">
				<xsl:attribute name="value">
					<xsl:value-of select="."/>
				</xsl:attribute>
			</field>
		</xsl:for-each>

		<xsl:for-each select="./esf:resulttypes">
			<field name="resulttypes" multiplicity="true" indexId="resulttypes" label="Result Types">
				<xsl:attribute name="value">
					<xsl:value-of select="."/>
				</xsl:attribute>
			</field>
		</xsl:for-each>

		<field name="temporalresolution" multiplicity="false" indexId="temporalresolution" label="Temporal Resolution">
			<xsl:attribute name="value">
				<xsl:value-of select="./esf:temporalresolution"/>
			</xsl:attribute>
		</field>

		<xsl:for-each select="./esf:observationcollection">
			<field name="observationcollection" multiplicity="true" label="Observation Collection">
				<field name="id" multiplicity="false" indexId="observationcollectionid" label="observationcollectionid">
					<xsl:attribute name="value">
						<xsl:value-of select="./esf:id"/>
					</xsl:attribute>
				</field>
				<field name="name" multiplicity="false" indexId="observationcollectionname" label="observationcollectionname">
					<xsl:attribute name="value">
						<xsl:value-of select="./esf:name"/>
					</xsl:attribute>
				</field>
			</field>
		</xsl:for-each>

		<xsl:for-each select="./esf:observedproperty">
			<field name="observedproperty" multiplicity="true" label="Observed Property">
				<field name="id" multiplicity="false" indexId="observedproperty" label="observedpropertyid">
					<xsl:attribute name="value">
						<xsl:value-of select="./esf:id"/>
					</xsl:attribute>
				</field>
				<field name="name" multiplicity="false" indexId="observedproperty" label="observedpropertyname">
					<xsl:attribute name="value">
						<xsl:value-of select="./esf:name"/>
					</xsl:attribute>
				</field>
				<field name="extracted" multiplicity="false" indexId="observedproperty" label="observedpropertyextracted">
					<xsl:attribute name="value">
						<xsl:value-of select="./esf:extracted"/>
					</xsl:attribute>
				</field>
			</field>
		</xsl:for-each>

		<xsl:for-each select="./esf:licence">
			<field name="licence" multiplicity="true" label="Licence">
				<field name="id" multiplicity="false" indexId="licenceid" label="Licence Id">
					<xsl:attribute name="value">
						<xsl:value-of select="./esf:id"/>
					</xsl:attribute>
				</field>
				<field name="name" multiplicity="false" indexId="licencename" label="Licence Name">
					<xsl:attribute name="value">
						<xsl:value-of select="./esf:name"/>
					</xsl:attribute>
				</field>
				<field name="definition" multiplicity="false" indexId="licencedefinition" label="Licence Definition">
					<xsl:attribute name="value">
						<xsl:value-of select="./esf:definition"/>
					</xsl:attribute>
				</field>
			</field>
		</xsl:for-each>

		<xsl:for-each select="./esf:procedure">
			<field name="procedure" multiplicity="true" label="Procedure">
				<field name="id" multiplicity="false" indexId="procedureid" label="procedureid">
					<xsl:attribute name="value">
						<xsl:value-of select="./esf:id"/>
					</xsl:attribute>
				</field>
				<field name="name" multiplicity="false" indexId="procedurename" label="procedurename">
					<xsl:attribute name="value">
						<xsl:value-of select="./esf:name"/>
					</xsl:attribute>
				</field>
			</field>
		</xsl:for-each>

		<xsl:for-each select="./esf:computation">
			<field name="computation" multiplicity="true" label="Computation">
				<field name="id" multiplicity="false" indexId="computationid" label="computationid">
					<xsl:attribute name="value">
						<xsl:value-of select="./esf:id"/>
					</xsl:attribute>
				</field>
				<field name="name" multiplicity="false" indexId="computationname" label="computationname">
					<xsl:attribute name="value">
						<xsl:value-of select="./esf:name"/>
					</xsl:attribute>
				</field>
			</field>
		</xsl:for-each>

		<xsl:for-each select="./esf:instrument">
			<field name="instrument" multiplicity="true" label="Instrument">
				<field name="id" multiplicity="false" indexId="instrumentid" label="instrumentid">
					<xsl:attribute name="value">
						<xsl:value-of select="./esf:id"/>
					</xsl:attribute>
				</field>
				<field name="name" multiplicity="false" indexId="instrumentname" label="instrumentname">
					<xsl:attribute name="value">
						<xsl:value-of select="./esf:name"/>
					</xsl:attribute>
				</field>
			</field>
		</xsl:for-each>

		<xsl:for-each select="./esf:dimensionalityinstance">
			<field name="dimensionalityinstance" multiplicity="true" label="Dimensionality Instance">
				<field name="id" multiplicity="false" indexId="dimensionalityinstanceid" label="dimensionalityinstanceid">
					<xsl:attribute name="value">
						<xsl:value-of select="./esf:id"/>
					</xsl:attribute>
				</field>
				<field name="name" multiplicity="false" indexId="dimensionalityinstancename" label="dimensionalityinstancename">
					<xsl:attribute name="value">
						<xsl:value-of select="./esf:name"/>
					</xsl:attribute>
				</field>
			</field>
		</xsl:for-each>

		<xsl:for-each select="./esf:dimensionalitytimeline">
			<field name="dimensionalitytimeline" multiplicity="true" label="Dimensionality Timeline">
				<field name="id" multiplicity="false" indexId="dimensionalitytimelineid" label="dimensionalitytimelineid">
					<xsl:attribute name="value">
						<xsl:value-of select="./esf:id"/>
					</xsl:attribute>
				</field>
				<field name="name" multiplicity="false" indexId="dimensionalitytimelinename" label="dimensionalitytimelinename">
					<xsl:attribute name="value">
						<xsl:value-of select="./esf:name"/>
					</xsl:attribute>
				</field>
			</field>
		</xsl:for-each>

		<xsl:for-each select="./esf:platform">
			<field name="platform" multiplicity="true" label="Platform">
				<field name="id" multiplicity="false" indexId="platformid" label="platformid">
					<xsl:attribute name="value">
						<xsl:value-of select="./esf:id"/>
					</xsl:attribute>
				</field>
				<field name="name" multiplicity="false" indexId="platformname" label="platformname">
					<xsl:attribute name="value">
						<xsl:value-of select="./esf:name"/>
					</xsl:attribute>
				</field>
			</field>
		</xsl:for-each>

		<xsl:for-each select="./esf:project">
			<field name="project" multiplicity="true" label="Project">
				<field name="id" multiplicity="false" indexId="projectid" label="projectid">
					<xsl:attribute name="value">
						<xsl:value-of select="./esf:id"/>
					</xsl:attribute>
				</field>
				<field name="name" multiplicity="false" indexId="projectid" label="projectid">
					<xsl:attribute name="value">
						<xsl:value-of select="./esf:name"/>
					</xsl:attribute>
				</field>
			</field>
		</xsl:for-each>

		<xsl:for-each select="./esf:regionofspace">
			<field name="regionofspace" multiplicity="true" label="Region of Space">
				<field name="id" multiplicity="false" indexId="regionofspaceid" label="regionofspaceid">
					<xsl:attribute name="value">
						<xsl:value-of select="./esf:id"/>
					</xsl:attribute>
				</field>
				<field name="name" multiplicity="false" indexId="regionofspacename" label="regionofspacename">
					<xsl:attribute name="value">
						<xsl:value-of select="./esf:name"/>
					</xsl:attribute>
				</field>
			</field>
		</xsl:for-each>

	</xsl:template>

</xsl:stylesheet>