package eu.dnetlib.espas.gui.client;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import eu.dnetlib.espas.gui.shared.ActiveTopicQuestions;
import eu.dnetlib.espas.gui.shared.Question;
import eu.dnetlib.espas.gui.shared.Topic;

import java.util.List;

/**
 * Created by stefania on 10/14/15.
 */
@RemoteServiceRelativePath("faqService")
public interface FAQService extends RemoteService {

    List<Topic> getTopics();

    void insertTopic(Topic topic);

    void updateTopic(Topic topic);

    void deleteTopics(List<String> topicIds);

    void setWeightQuestionOrder(List<String> topicIds);

    void setHitCountQuestionOrder(List<String> topicIds);

    List<Question> getQuestions(String topicId);

    void insertQuestion(Question question);

    void updateQuestion(Question question);

    void deleteQuestions(List<String> questionIds);

    void setQuestionsActive(List<String> questionIds);

    void setQuestionsInactive(List<String> questionIds);

    void incrementQuestionHitCount(String questionId);

    List<ActiveTopicQuestions> getActiveFAQs();
}
