package eu.dnetlib.espas.gui.server;

import eu.dnetlib.espas.gui.shared.Message;
import org.apache.log4j.Logger;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.annotation.Transactional;

import javax.sql.DataSource;
import java.sql.*;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by stefania on 2/24/15.
 */
@Transactional(readOnly = false)
public class MessageServiceCore {

    private DataSource datasource = null;

    private static Logger logger = Logger.getLogger(MessageServiceCore.class);

    private final static String GET_VALID_MESSAGES = "select * from messages where now() between validfrom and validto;";

    private final static String GET_MESSAGES = "select * from messages order by dateinserted;";

    private final static String DELETE_MESSAGE = "delete from messages where id = ? ;";

    private final static String INSERT_MESSAGE = "insert into messages (validfrom, validto, message) values (?, ?, ?);";

    private final static String UPDATE_MESSAGE = "update messages set validfrom = ?, validto = ?, message = ? where id = ? ;";

    public List<String> getValidMessages() {

        List<String> messages = new ArrayList<String>();

        try {

            Connection con = DataSourceUtils.getConnection(datasource);
            PreparedStatement stmt = con.prepareStatement(GET_VALID_MESSAGES);

            ResultSet rs = stmt.executeQuery();

            while (rs.next()) {
                messages.add(rs.getString("message"));
            }

            rs.close();
            stmt.close();
            DataSourceUtils.releaseConnection(con, datasource);

        } catch (SQLException e) {
            logger.error("Failed to get valid messages", e);
        }

        return messages;
    }

    public List<Message> getMessages() {

        List<Message> messages = new ArrayList<Message>();

        try {

            Connection con = DataSourceUtils.getConnection(datasource);
            PreparedStatement stmt = con.prepareStatement(GET_MESSAGES);

            ResultSet rs = stmt.executeQuery();

            while (rs.next()) {

                Message message = new Message();
                message.setId(rs.getInt("id"));
                message.setDateInserted(rs.getTimestamp("dateinserted"));
                message.setValidFrom(rs.getTimestamp("validfrom"));
                message.setValidTo(rs.getTimestamp("validto"));
                message.setMessageText(rs.getString("message"));

                messages.add(message);
            }

            rs.close();
            stmt.close();
            DataSourceUtils.releaseConnection(con, datasource);

        } catch (SQLException e) {
            logger.error("Failed to get valid messages", e);
        }

        return messages;
    }

    public void deleteMessage(String messageId) {

        try {

            Connection con = DataSourceUtils.getConnection(datasource);
            PreparedStatement stmt = con.prepareStatement(DELETE_MESSAGE);

            stmt.setInt(1, Integer.parseInt(messageId));

            stmt.executeUpdate();

            stmt.close();
            DataSourceUtils.releaseConnection(con, datasource);

        } catch (SQLException e) {
            logger.error("Failed to delete message", e);
        }
    }

    public void insertMessage(Message message) {

        try {

            Connection con = DataSourceUtils.getConnection(datasource);
            PreparedStatement stmt = con.prepareStatement(INSERT_MESSAGE);

            stmt.setTimestamp(1, new java.sql.Timestamp(message.getValidFrom().getTime()));
            stmt.setTimestamp(2, new java.sql.Timestamp(message.getValidTo().getTime()));
            stmt.setString(3, message.getMessageText());

            stmt.executeUpdate();

            stmt.close();
            DataSourceUtils.releaseConnection(con, datasource);

        } catch (SQLException e) {
            logger.error("Failed to insert message", e);
        }
    }

    public void updateMessage(Message message) {

        try {

            Connection con = DataSourceUtils.getConnection(datasource);
            PreparedStatement stmt = con.prepareStatement(UPDATE_MESSAGE);

            stmt.setTimestamp(1, new java.sql.Timestamp(message.getValidFrom().getTime()));
            stmt.setTimestamp(2, new java.sql.Timestamp(message.getValidTo().getTime()));
            stmt.setString(3, message.getMessageText());
            stmt.setInt(4, message.getId());

            stmt.executeUpdate();

            stmt.close();
            DataSourceUtils.releaseConnection(con, datasource);

        } catch (SQLException e) {
            logger.error("Failed to update message", e);
        }
    }

    public DataSource getDatasource() {
        return datasource;
    }

    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
    }
}
