package eu.dnetlib.espas.gui.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import eu.dnetlib.espas.gui.client.MessageService;
import eu.dnetlib.espas.gui.shared.Message;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import java.util.List;

/**
 * Created by stefania on 2/24/15.
 */
public class MessageServiceImpl extends RemoteServiceServlet implements MessageService {

    private MessageServiceCore messageServiceCore = null;

    public void init(ServletConfig config) throws ServletException {

        super.init(config);
        ApplicationContext datasourceContext = WebApplicationContextUtils
                .getWebApplicationContext(getServletContext());
        this.messageServiceCore = (MessageServiceCore) datasourceContext.getBean("espas.gui.messageServiceCore");
    }

    @Override
    public List<String> getValidMessages() {
        return messageServiceCore.getValidMessages();
    }

    @Override
    public List<Message> getMessages() {
        return messageServiceCore.getMessages();
    }

    @Override
    public void deleteMessages(List<String> messageIds) {
        for(String messageId : messageIds)
            messageServiceCore.deleteMessage(messageId);
    }

    @Override
    public void insertMessage(Message message) {
        messageServiceCore.insertMessage(message);
    }

    @Override
    public void updateMessage(Message message) {
        messageServiceCore.updateMessage(message);
    }
}
