package eu.dnetlib.espas.gui.server.user;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.UUID;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;

import net.tanesha.recaptcha.ReCaptchaImpl;
import net.tanesha.recaptcha.ReCaptchaResponse;

import org.joda.time.DateTime;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.support.WebApplicationContextUtils;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

import eu.dnetlib.espas.gui.client.UserService;
import eu.dnetlib.espas.gui.server.utils.EmailUtils;
import eu.dnetlib.espas.gui.shared.User;
import eu.dnetlib.espas.gui.shared.UserAccessException;
import eu.dnetlib.espas.gui.shared.UserAccessException.ErrorCode;

@SuppressWarnings("serial")
public class UserServiceImpl extends RemoteServiceServlet implements UserService {
	
	private UserDAO userDAO;
	private EmailUtils emailUtils;
	
	private String hostName;
	private String publicCaptchaKey;
	private String privateCaptchaKey;

	private boolean useProxy;
	private String proxyHost;
	private int proxyPort;
	
	private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	
	public void init(ServletConfig config) throws ServletException {
		
		super.init(config);
		ApplicationContext context = WebApplicationContextUtils
				.getWebApplicationContext(getServletContext());
		
		userDAO = (UserDAO) context.getBean("espas.gui.userDao");
		emailUtils = (EmailUtils) context.getBean("espas.gui.emailUtils");
		hostName = (String) context.getBean("espas.gui.hostName");
		publicCaptchaKey = (String) context.getBean("espas.gui.publicCaptchaKey");
		privateCaptchaKey = (String) context.getBean("espas.gui.privateCaptchaKey");

		useProxy = (Boolean) context.getBean("espas.gui.captcha.useProxy");
		proxyHost = (String) context.getBean("espas.gui.captcha.proxy.host");
		proxyPort = (Integer) context.getBean("espas.gui.captcha.proxy.port");
	}
	
	@Override
	public void insertUser(User user, String challenge, String response) throws UserAccessException {
		
//		ReCaptchaImpl reCaptcha = new ReCaptchaImpl();
//
//		if (useProxy)
//			reCaptcha.setHttpLoader(new SimpleProxyHttpLoader(proxyHost, proxyPort));
//
//        reCaptcha.setPrivateKey(privateCaptchaKey);
//
//        ReCaptchaResponse reCaptchaResponse = reCaptcha.checkAnswer(hostName, challenge, response);
//
//        if (!reCaptchaResponse.isValid())
//        	throw new UserAccessException(ErrorCode.INCORRECT_CAPTCHA);
		
		user.setActivationId(UUID.randomUUID().toString());
		user.setActivated(false);
		userDAO.insertUser(user);
		
		emailUtils.sendActivationEmail(user);
	}

	@Override
	public User getUserById(String userEmail, String password) throws UserAccessException {
		return userDAO.getUserById(userEmail, password);
	}

	@Override
	public User getUserById(String userEmail) throws UserAccessException {
		return userDAO.getUserById(userEmail);
	}

	@Override
	public void updateUser(User user) throws UserAccessException {
		userDAO.updateUser(user);
	}

	@Override
	public User activateUser(User user) throws UserAccessException {
		return userDAO.activateUser(user);
	}

	@Override
	public void resetPassword(User user, String challenge, String response) throws UserAccessException {
		
//        ReCaptchaImpl reCaptcha = new ReCaptchaImpl();
//
//		if (useProxy)
//			reCaptcha.setHttpLoader(new SimpleProxyHttpLoader(proxyHost, proxyPort));
//
//        reCaptcha.setPrivateKey(privateCaptchaKey);
//
//        ReCaptchaResponse reCaptchaResponse = reCaptcha.checkAnswer(hostName, challenge, response);
//
//        if (!reCaptchaResponse.isValid())
//        	throw new UserAccessException(ErrorCode.INCORRECT_CAPTCHA);
        
        if(getUserById(user.getEmail())==null)
			throw new UserAccessException(ErrorCode.INVALID_USERNAME);
        
        String resetToken = user.getEmail() + "::" + UUID.randomUUID().toString() + "::" + sdf.format(new DateTime().plusDays(1).toDate());
        userDAO.updateResetToken(user.getEmail(), resetToken);
        
        emailUtils.sendResetPasswordEmail(user, resetToken);
	}

	@Override
	public String getPublicCaptchaKey() {
		return publicCaptchaKey;
	}

	@Override
	public void updateUserPassword(String userEmail, String password)
			throws UserAccessException {
		userDAO.updateUserPassword(userEmail, password);
	}

	@Override
	public List<User> getUsers() throws UserAccessException {
		return userDAO.getUsers();
	}

	@Override
	public void activateUsers(List<String> emails) throws UserAccessException {
		userDAO.activateUsers(emails);
	}

	@Override
	public void deactivateUsers(List<String> emails) throws UserAccessException {
		userDAO.deactivateUsers(emails);
	}

	@Override
	public void deleteUsers(List<String> emails) throws UserAccessException {
		userDAO.deleteUsers(emails);
	}

	@Override
	public void addRoleToUser(String email, String role)
			throws UserAccessException {
		userDAO.addRoleToUser(email, role);
	}

	@Override
	public void removeRoleFromUser(String email, String role)
			throws UserAccessException {
		userDAO.removeRoleFromUser(email, role);
	}

	@Override
	public void denyDataProviderRoleToUser(String email)
			throws UserAccessException {
		userDAO.denyDataProviderRoleToUser(email);
	}

	@Override
	public List<String> getDataProviderUsersEmails() throws UserAccessException {
		return userDAO.getDataProviderUsersEmails();
	}

    @Override
    public List<User> getDataProviderUsers() {
        return userDAO.getDataProviderUsers();
    }
}
