package eu.dnetlib.espas.gui.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;

public interface FAQServiceAsync
{

    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.espas.gui.client.FAQService
     */
    void getTopics( AsyncCallback<java.util.List<eu.dnetlib.espas.gui.shared.Topic>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.espas.gui.client.FAQService
     */
    void insertTopic( eu.dnetlib.espas.gui.shared.Topic topic, AsyncCallback<Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.espas.gui.client.FAQService
     */
    void updateTopic( eu.dnetlib.espas.gui.shared.Topic topic, AsyncCallback<Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.espas.gui.client.FAQService
     */
    void deleteTopics( java.util.List<java.lang.String> topicIds, AsyncCallback<Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.espas.gui.client.FAQService
     */
    void setWeightQuestionOrder( java.util.List<java.lang.String> topicIds, AsyncCallback<Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.espas.gui.client.FAQService
     */
    void setHitCountQuestionOrder( java.util.List<java.lang.String> topicIds, AsyncCallback<Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.espas.gui.client.FAQService
     */
    void getQuestions( java.lang.String topicId, AsyncCallback<java.util.List<eu.dnetlib.espas.gui.shared.Question>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.espas.gui.client.FAQService
     */
    void insertQuestion( eu.dnetlib.espas.gui.shared.Question question, AsyncCallback<Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.espas.gui.client.FAQService
     */
    void updateQuestion( eu.dnetlib.espas.gui.shared.Question question, AsyncCallback<Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.espas.gui.client.FAQService
     */
    void deleteQuestions( java.util.List<java.lang.String> questionIds, AsyncCallback<Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.espas.gui.client.FAQService
     */
    void setQuestionsActive( java.util.List<java.lang.String> questionIds, AsyncCallback<Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.espas.gui.client.FAQService
     */
    void setQuestionsInactive( java.util.List<java.lang.String> questionIds, AsyncCallback<Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.espas.gui.client.FAQService
     */
    void incrementQuestionHitCount( java.lang.String questionId, AsyncCallback<Void> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see eu.dnetlib.espas.gui.client.FAQService
     */
    void getActiveFAQs( AsyncCallback<java.util.List<eu.dnetlib.espas.gui.shared.ActiveTopicQuestions>> callback );


    /**
     * Utility class to get the RPC Async interface from client-side code
     */
    public static final class Util 
    { 
        private static FAQServiceAsync instance;

        public static final FAQServiceAsync getInstance()
        {
            if ( instance == null )
            {
                instance = (FAQServiceAsync) GWT.create( FAQService.class );
            }
            return instance;
        }

        private Util()
        {
            // Utility class should not be instanciated
        }
    }
}
