package eu.dnetlib.espas.gui.client;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.sencha.gxt.data.shared.TreeStore.TreeNode;

@SuppressWarnings("serial")
public class BaseDto implements Serializable, TreeNode<BaseDto> {

	private String id;
	private String localId;
	private String name;
	private String shortlabel;
	private String description;
	private boolean isHeader;
	private String type;
	
	private Map<String, String> extraProperties;
	
	protected BaseDto() {

	}

	public BaseDto(String id, String name, String shortlabel, String description, boolean isHeader, String type) {
		this.id = id;
		this.name = name;
		this.shortlabel = shortlabel;
		this.description = description;
		this.isHeader = isHeader;
		this.type = type;
		extraProperties = new HashMap<String, String>();
	}
	
	public BaseDto(String id, String name, String shortlabel, String description, boolean isHeader, String type, Map<String, String> extraProperties) {
		this.id = id;
		this.name = name;
		this.shortlabel = shortlabel;
		this.description = description;
		this.isHeader = isHeader;
		this.type = type;
		this.extraProperties = extraProperties;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}
	
	public String getLocalId() {
		return localId;
	}

	public void setLocalId(String localId) {
		this.localId = localId;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	public String getShortlabel() {
		return shortlabel;
	}

	public void setShortlabel(String shortlabel) {
		this.shortlabel = shortlabel;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public boolean isHeader() {
		return isHeader;
	}

	public void setHeader(boolean isHeader) {
		this.isHeader = isHeader;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}
	
	public Map<String, String> getExtraProperties() {
		return extraProperties;
	}

	public void setExtraProperties(Map<String, String> extraProperties) {
		this.extraProperties = extraProperties;
	}

	@Override
	public BaseDto getData() {
		return this;
	}

	@Override
	public List<? extends TreeNode<BaseDto>> getChildren() {
		return null;
	}

	@Override
	public String toString() {
		return name != null ? name : super.toString();
	}
}