package eu.dnetlib.espas.gui.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import eu.dnetlib.espas.gui.client.FAQService;
import eu.dnetlib.espas.gui.shared.ActiveTopicQuestions;
import eu.dnetlib.espas.gui.shared.Question;
import eu.dnetlib.espas.gui.shared.Topic;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import java.util.List;

/**
 * Created by stefania on 10/14/15.
 */
public class FAQServiceImpl extends RemoteServiceServlet implements FAQService {

    private FAQServiceCore faqServiceCore = null;

    public void init(ServletConfig config) throws ServletException {

        super.init(config);
        ApplicationContext datasourceContext = WebApplicationContextUtils
                .getWebApplicationContext(getServletContext());
        this.faqServiceCore = (FAQServiceCore) datasourceContext.getBean("espas.gui.faqServiceCore");
    }

    @Override
    public List<Topic> getTopics() {
        return faqServiceCore.getTopics();
    }

    @Override
    public void insertTopic(Topic topic) {
        faqServiceCore.insertTopic(topic);
    }

    @Override
    public void updateTopic(Topic topic) {
        faqServiceCore.updateTopic(topic);
    }

    @Override
    public void deleteTopics(List<String> topicIds) {
        for (String topicId : topicIds)
            faqServiceCore.deleteTopic(topicId);
    }

    @Override
    public void setWeightQuestionOrder(List<String> topicIds) {
        for (String topicId : topicIds)
            faqServiceCore.setWeightQuestionOrder(topicId);
    }

    @Override
    public void setHitCountQuestionOrder(List<String> topicIds) {
        for (String topicId : topicIds)
            faqServiceCore.setHitCountQuestionOrder(topicId);
    }

    @Override
    public List<Question> getQuestions(String topicId) {
        if(topicId!=null)
            return faqServiceCore.getQuestionsById(topicId);
        else
            return faqServiceCore.getQuestions();
    }

    @Override
    public void insertQuestion(Question question) {
        faqServiceCore.insertQuestion(question);
    }

    @Override
    public void updateQuestion(Question question) {
        faqServiceCore.updateQuestion(question);
    }

    @Override
    public void deleteQuestions(List<String> questionIds) {
        for(String questionId : questionIds)
            faqServiceCore.deleteQuestion(questionId);
    }

    @Override
    public void setQuestionsActive(List<String> questionIds) {
        for(String questionId : questionIds)
            faqServiceCore.setQuestionActive(questionId);
    }

    @Override
    public void setQuestionsInactive(List<String> questionIds) {
        for(String questionId : questionIds)
            faqServiceCore.setQuestionInactive(questionId);
    }

    @Override
    public void incrementQuestionHitCount(String questionId) {
        faqServiceCore.incrementQuestionHitCount(questionId);
    }

    @Override
    public List<ActiveTopicQuestions> getActiveFAQs() {
        return faqServiceCore.getActiveFAQs();
    }
}
