package eu.dnetlib.espas.gui.server.user;

import java.util.List;
import java.util.Map;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;

import eu.dnetlib.espas.gui.shared.DataProviderStatus;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

import eu.dnetlib.espas.gui.client.user.DataProviderAccessService;
import eu.dnetlib.espas.gui.shared.DataProvider;
import eu.dnetlib.espas.gui.shared.UserAccessException;

@SuppressWarnings("serial")
public class DataProviderAccessServiceImpl extends RemoteServiceServlet implements DataProviderAccessService {
	
    private DataProviderAccessServiceCore dataProviderAccessServiceCore = null;

	public void init(ServletConfig config) throws ServletException {
		
		super.init(config);
		ApplicationContext datasourceContext = WebApplicationContextUtils
				.getWebApplicationContext(getServletContext());
		this.dataProviderAccessServiceCore = (DataProviderAccessServiceCore) datasourceContext.getBean("espas.gui.dataProviderAccessServiceCore");
	}


    @Override
    public List<DataProvider> getDataProvidersByUser(String userId) throws UserAccessException {
        return dataProviderAccessServiceCore.getDataProvidersByUser(userId);
    }

    @Override
    public void saveDataProvider(DataProvider dataProvider) throws UserAccessException {
        dataProviderAccessServiceCore.saveDataProvider(dataProvider);
    }

    @Override
    public void updateDataProvider(DataProvider dataProvider) throws UserAccessException {
        dataProviderAccessServiceCore.updateDataProvider(dataProvider);
    }

    @Override
    public void deleteDataProvider(DataProvider dataProvider) throws UserAccessException {
        dataProviderAccessServiceCore.deleteDataProvider(dataProvider);
    }

    @Override
    public DataProvider getDataProviderByNamespace(String namespace) throws UserAccessException {
        return dataProviderAccessServiceCore.getDataProviderByNamespace(namespace);
    }

    @Override
    public List<DataProvider> getDataProviders() throws UserAccessException {
        return dataProviderAccessServiceCore.getDataProviders();
    }

    @Override
    public List<DataProviderStatus> getAllDataProviderStatuses() throws UserAccessException {
        return dataProviderAccessServiceCore.getAllDataProviderStatuses();
    }

    @Override
    public List<DataProviderStatus> getDataProviderStatuses(List<String> namespaces) throws UserAccessException {
        return dataProviderAccessServiceCore.getDataProviderStatuses(namespaces);
    }

    @Override
    public Map<String, Integer> getEntriesCount(String dataProviderId) throws UserAccessException {
        return dataProviderAccessServiceCore.getEntriesCount(dataProviderId);
    }

    @Override
    public void deleteDataProvider(String dataProviderId) throws UserAccessException {
        dataProviderAccessServiceCore.deleteDataProvider(dataProviderId);
    }
}
